/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.wst.server.core.IServer;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.views.content.ITeiidContainerNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TeiidDataNode;
import org.teiid.designer.runtime.ui.views.content.TeiidServerContainerNode;

public abstract class AbstractTeiidFolder<V>
implements ITeiidContainerNode<TeiidServerContainerNode> {
    private TeiidServerContainerNode parentNode;
    private Collection<V> theValues;
    private ITeiidServer teiidServer;
    private List<ITeiidContentNode<? extends ITeiidContainerNode<?>>> children;

    public AbstractTeiidFolder(TeiidServerContainerNode parentNode, Collection<V> theValues) {
        this.parentNode = parentNode;
        this.teiidServer = parentNode.getTeiidServer();
        this.theValues = theValues;
    }

    @Override
    public IServer getServer() {
        return this.teiidServer != null ? this.teiidServer.getParent() : null;
    }

    public ITeiidServer getTeiidServer() {
        return this.teiidServer;
    }

    @Override
    public ITeiidResourceNode getParent() {
        return this.parentNode != null ? this.parentNode.getParent() : null;
    }

    @Override
    public TeiidServerContainerNode getContainer() {
        return this.parentNode;
    }

    @Override
    public void load() {
        this.clearChildren();
        if (this.getTeiidServer() == null || !this.getTeiidServer().isConnected()) {
            return;
        }
        this.children = new ArrayList();
        for (V value : this.theValues) {
            TeiidDataNode<V> dataNode = new TeiidDataNode<V>(this, value);
            this.children.add(dataNode);
        }
    }

    @Override
    public List<? extends ITeiidContentNode<?>> getChildren() {
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    private void clearChildren() {
        if (this.children != null) {
            for (ITeiidContentNode<ITeiidContainerNode<?>> child : this.children) {
                child.dispose();
            }
            this.children.clear();
            this.children = null;
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void dispose() {
        this.parentNode = null;
        this.teiidServer = null;
        this.theValues = null;
    }
}

