/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.jcip.annotations.GuardedBy;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.as.wst.server.ui.xpl.ServerToolTip;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.runtime.ui.views.TeiidServerPreviewOptionContributor;
import org.teiid.designer.runtime.ui.views.content.AbstractTeiidFolder;
import org.teiid.designer.runtime.ui.views.content.DataSourcesFolder;
import org.teiid.designer.runtime.ui.views.content.ITeiidContainerNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TeiidDataNode;
import org.teiid.designer.runtime.ui.views.content.TeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TranslatorsFolder;
import org.teiid.designer.runtime.ui.views.content.VdbsFolder;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class TeiidServerContentProvider
implements ICommonContentProvider {
    private static final Object PENDING = new Object();
    private static final Object REFRESH = new Object();
    private ConcurrentMap<ITeiidContainerNode, Object> pendingUpdates = new ConcurrentHashMap<ITeiidContainerNode, Object>();
    private transient TreeViewer viewer;
    @GuardedBy(value="offlineServersLock")
    private final Map<ITeiidServer, Long> offlineServerMap = new HashMap<ITeiidServer, Long>();
    private boolean showVDBs = true;
    private boolean showDataSources = true;
    private boolean showTranslators = true;
    private IExecutionConfigurationListener configListener = new IExecutionConfigurationListener(){

        public void configurationChanged(ExecutionConfigurationEvent event) {
            if (ExecutionConfigurationEvent.EventType.CONNECTING.equals((Object)event.getEventType())) {
                TeiidServerContentProvider.this.refreshThread.schedulePending();
                return;
            }
            if (ExecutionConfigurationEvent.EventType.CONNECTED.equals((Object)event.getEventType())) {
                return;
            }
            TeiidServerContentProvider.this.refreshThread.scheduleRefresh();
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TeiidServerPreviewOptionContributor.PREVIEW_OPTIONS_PROPERTY.equals(evt.getPropertyName())) {
                if (TeiidServerContentProvider.this.viewer == null || TeiidServerContentProvider.this.viewer.isBusy()) {
                    return;
                }
                TeiidServerContentProvider.this.refreshThread.scheduleRefresh();
            }
        }
    };
    private final TeiidServerPreviewOptionContributor previewOptionContributor;
    private RefreshThread refreshThread = new RefreshThread();
    private ServerToolTip tooltip;

    public TeiidServerContentProvider() {
        this.refreshThread.start();
        DqpPlugin.getInstance().getServerManager().addListener(this.configListener);
        this.previewOptionContributor = TeiidServerPreviewOptionContributor.getDefault();
        this.previewOptionContributor.addPropertyChangeListener(this.propertyChangeListener);
    }

    public TeiidServerContentProvider(boolean showVDBs, boolean showTranslators, boolean showDataSources) {
        this();
        this.showVDBs = showVDBs;
        this.showTranslators = showTranslators;
        this.showDataSources = showDataSources;
    }

    public boolean isShowDataSources() {
        return this.showDataSources;
    }

    public boolean isShowPreviewDataSources() {
        return this.previewOptionContributor.isShowPreviewDataSources();
    }

    public boolean isShowVDBs() {
        return this.showVDBs;
    }

    public boolean isShowPreviewVDBs() {
        return this.previewOptionContributor.isShowPreviewVdbs();
    }

    public boolean isShowTranslators() {
        return this.showTranslators;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == null) {
            return new Object[0];
        }
        if (parentElement instanceof IServer) {
            ITeiidResourceNode node = TeiidResourceNode.getInstance((IServer)parentElement, this);
            node.setDirty();
            return new Object[]{node};
        }
        if (parentElement instanceof ITeiidContainerNode) {
            ITeiidContainerNode container = (ITeiidContainerNode)parentElement;
            if (this.pendingUpdates.containsKey(container)) {
                return new Object[]{PENDING};
            }
            List<ITeiidContentNode<?>> children = container.getChildren();
            if (children == null) {
                this.pendingUpdates.putIfAbsent(container, PENDING);
                this.refreshThread.schedulePending();
                return new Object[]{PENDING};
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof ITeiidContentNode) {
            Object parent = ((ITeiidContentNode)element).getContainer();
            if (parent == null) {
                parent = ((ITeiidContentNode)element).getServer();
            }
            return parent;
        }
        return null;
    }

    public Object getDataSourceFolder(Object server) {
        Object[] objectArray = this.getChildren(server);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof DataSourcesFolder) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public Object getTranslatorFolder(Object server) {
        Object[] objectArray = this.getChildren(server);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof TranslatorsFolder) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public Object getVdbFolder(Object server) {
        Object[] objectArray = this.getChildren(server);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof VdbsFolder) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    static Object getPending() {
        return PENDING;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IServer) {
            return true;
        }
        return element instanceof ITeiidContainerNode;
    }

    private boolean isTeiidResourceNode(Object o) {
        return o instanceof ITeiidResourceNode;
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.restoreState(aConfig.getMemento());
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
            if (this.tooltip != null) {
                this.tooltip.deactivate();
            }
            this.tooltip = new ServerToolTip(this.viewer.getTree()){

                protected boolean isMyType(Object selected) {
                    return RuntimeAssistant.adapt(selected, AbstractTeiidFolder.class) != null || RuntimeAssistant.adapt(selected, TeiidDataNode.class) != null || RuntimeAssistant.adapt(selected, ITeiidServer.class) != null;
                }

                protected void fillStyledText(Composite parent, StyledText sText, Object o) {
                    if (o instanceof TreeItem) {
                        String text = ((TreeItem)o).getData().toString();
                        sText.setText(text.replace("\n", "<br>"));
                    }
                }
            };
            this.tooltip.setShift(new Point(15, 8));
            this.tooltip.setPopupDelay(500);
            this.tooltip.setHideOnMouseDown(true);
            this.tooltip.activate();
        } else {
            this.viewer = null;
        }
    }

    public void dispose() {
        this.viewer = null;
        this.pendingUpdates.clear();
        DqpPlugin.getInstance().getServerManager().removeListener(this.configListener);
        this.refreshThread.die();
        this.refreshThread = null;
    }

    public void saveState(IMemento memento) {
        this.previewOptionContributor.saveState(memento);
    }

    public void restoreState(IMemento aMemento) {
        this.previewOptionContributor.restoreState(aMemento);
    }

    private class RefreshThread
    extends Thread {
        private boolean die;
        private boolean busy;
        private LinkedBlockingQueue<Object> queue;

        public RefreshThread() {
            super(TeiidServerContentProvider.this + "." + RefreshThread.class.getSimpleName());
            this.die = false;
            this.busy = false;
            this.queue = new LinkedBlockingQueue();
            this.setDaemon(true);
        }

        public void die() {
            this.die = true;
        }

        public void scheduleRefresh() {
            if (this.die) {
                return;
            }
            this.queue.add(REFRESH);
        }

        public void schedulePending() {
            if (this.die) {
                return;
            }
            this.queue.add(PENDING);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && !this.die) {
                try {
                    if (!this.busy) {
                        Object queueObject = this.queue.take();
                        if (PENDING.equals(queueObject)) {
                            this.loadPending();
                        } else if (REFRESH.equals(queueObject)) {
                            this.loadRefresh();
                        }
                    }
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void loadPending() {
            this.busy = true;
            final ArrayList<ITeiidContainerNode> updated = new ArrayList<ITeiidContainerNode>(TeiidServerContentProvider.this.pendingUpdates.size());
            for (ITeiidContainerNode node : TeiidServerContentProvider.this.pendingUpdates.keySet()) {
                try {
                    node.load();
                    updated.add(node);
                }
                catch (Exception exception) {}
            }
            if (TeiidServerContentProvider.this.viewer == null) {
                TeiidServerContentProvider.this.pendingUpdates.keySet().clear();
            } else {
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (TeiidServerContentProvider.this.viewer.getControl().isDisposed()) {
                                return;
                            }
                            for (Object node : updated) {
                                TeiidServerContentProvider.this.pendingUpdates.remove(node);
                                TeiidServerContentProvider.this.viewer.refresh(node);
                                if (!(node instanceof ITeiidResourceNode)) continue;
                                TeiidServerContentProvider.this.viewer.setExpandedState(node, true);
                                TeiidServerContentProvider.this.viewer.expandToLevel(node, 2);
                            }
                        }
                        finally {
                            RefreshThread.this.busy = false;
                        }
                    }
                }, (boolean)true);
            }
        }

        private void loadRefresh() {
            this.busy = true;
            UiUtil.runInSwtThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (TeiidServerContentProvider.this.viewer.getTree().isDisposed()) {
                            return;
                        }
                        ITeiidResourceNode trn = null;
                        TreePath[] treePathArray = TeiidServerContentProvider.this.viewer.getExpandedTreePaths();
                        int n = treePathArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object[] children;
                            TreePath o = treePathArray[n2];
                            Object element = o.getLastSegment();
                            if (TeiidServerContentProvider.this.isTeiidResourceNode(element)) {
                                trn = (ITeiidResourceNode)element;
                                break;
                            }
                            Object[] objectArray = children = TeiidServerContentProvider.this.getChildren(element);
                            int n3 = children.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object child = objectArray[n4];
                                if (TeiidServerContentProvider.this.isTeiidResourceNode(child)) {
                                    trn = (ITeiidResourceNode)child;
                                    break;
                                }
                                ++n4;
                            }
                            if (TeiidServerContentProvider.this.isTeiidResourceNode(trn)) break;
                            ++n2;
                        }
                        TeiidServerContentProvider.this.viewer.refresh();
                        if (trn != null) {
                            TeiidServerContentProvider.this.viewer.setExpandedState(trn, true);
                            TeiidServerContentProvider.this.viewer.expandToLevel((Object)trn, 2);
                        }
                        ModelerUiViewUtils.refreshModelExplorerResourceNavigatorTree();
                    }
                    finally {
                        RefreshThread.this.busy = false;
                    }
                }
            }, (boolean)false);
        }
    }
}

