/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.ui.actions.IConnectionAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class SetJBossDataSourceNameAction
extends SortableSelectionAction
implements IConnectionAction {
    private static final String ACTION_TITLE = DqpUiConstants.UTIL.getString("SetJBossDataSourceNameAction.title", new Object[0]);
    private static final String DIALOG_TITLE = DqpUiConstants.UTIL.getString("EnterDataSourceJNDINameDialog.title", new Object[0]);
    private static final String SPACE = " ";
    private static final String JNDI_PREFIX = "java:/";
    private ConnectionInfoHelper connectionInfoHelper;

    public SetJBossDataSourceNameAction() {
        super(ACTION_TITLE, -1);
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/set-connection.png"));
        this.connectionInfoHelper = new ConnectionInfoHelper();
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    public void run() {
        IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
        ModelResource mr = ModelUtilities.getModelResourceForIFile((IFile)modelFile, (boolean)true);
        String existingName = this.connectionInfoHelper.getJndiProperty(mr);
        String nameOnly = "";
        if (!StringUtilities.isEmpty((String)existingName)) {
            nameOnly = existingName;
            if (existingName.startsWith(JNDI_PREFIX)) {
                nameOnly = existingName.substring(6);
            }
        }
        String newJNDIName = this.queryUserForJNDIName(nameOnly);
        if (existingName == null || !existingName.equals(newJNDIName)) {
            this.setJNDINameInTxn(mr, JNDI_PREFIX + newJNDIName);
        }
    }

    private void setJNDINameInTxn(ModelResource modelResource, String newJNDIName) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Data Source JNDI Name", (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    this.connectionInfoHelper.setJNDIName(modelResource, newJNDIName);
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DqpUiConstants.UTIL.getString("SetConnectionInfo.exceptionMessage", new Object[0]), (String)e.getMessage());
                Status status = new Status(4, "org.teiid.designer.dqp.ui", DqpUiConstants.UTIL.getString("SetConnectionInfo.exceptionMessage", new Object[0]), (Throwable)e);
                DqpUiConstants.UTIL.log((IStatus)status);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public String queryUserForJNDIName(String existingName) {
        EnterDataSourceJNDINameDialog dialog = new EnterDataSourceJNDINameDialog(Display.getCurrent().getActiveShell(), existingName);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            return dialog.getTranslatorName();
        }
        return existingName;
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    class EnterDataSourceJNDINameDialog
    extends Dialog {
        private static final int COLUMN_COUNT = 2;
        private Text jndiNameField;
        private String jndiName;

        public EnterDataSourceJNDINameDialog(Shell shell, String existingName) {
            super(shell, DIALOG_TITLE);
            this.jndiName = existingName;
        }

        protected Control createDialogArea(Composite parent) {
            Composite dlgPanel = (Composite)super.createDialogArea(parent);
            GridData pgd = new GridData(1, 0x1000000, true, true);
            pgd.minimumWidth = 400;
            pgd.grabExcessHorizontalSpace = true;
            dlgPanel.setLayoutData((Object)pgd);
            ((GridLayout)dlgPanel.getLayout()).numColumns = 2;
            String message = DqpUiConstants.UTIL.getString("EnterDataSourceJNDINameDialog.message", new Object[0]);
            Label msgLabel = WidgetFactory.createLabel((Composite)dlgPanel, (String)message);
            GridData gd = new GridData(1, 0x1000000, true, true);
            gd.horizontalSpan = 2;
            msgLabel.setLayoutData((Object)gd);
            WidgetFactory.createLabel((Composite)dlgPanel, (String)(String.valueOf(DqpUiConstants.UTIL.getString("EnterDataSourceJNDINameDialog.nameLabel", new Object[0])) + SetJBossDataSourceNameAction.SPACE));
            this.jndiNameField = WidgetFactory.createTextField((Composite)dlgPanel);
            if (this.jndiName != null && this.jndiName.length() > 0) {
                this.jndiNameField.setText(this.jndiName);
            }
            this.jndiNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (EnterDataSourceJNDINameDialog.this.jndiNameField.getText() != null && EnterDataSourceJNDINameDialog.this.jndiNameField.getText().length() > 0) {
                        EnterDataSourceJNDINameDialog.this.getButton(0).setEnabled(true);
                        EnterDataSourceJNDINameDialog.this.jndiName = EnterDataSourceJNDINameDialog.this.jndiNameField.getText();
                    } else {
                        EnterDataSourceJNDINameDialog.this.jndiName = "";
                        EnterDataSourceJNDINameDialog.this.getButton(0).setEnabled(false);
                    }
                }
            });
            return dlgPanel;
        }

        public void create() {
            super.create();
            this.getButton(0).setEnabled(this.jndiName != null);
        }

        protected void okPressed() {
            super.okPressed();
        }

        public String getTranslatorName() {
            return this.jndiName;
        }
    }
}

