/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.connection.CreateVdbDataSourceAction;
import org.teiid.designer.runtime.ui.vdb.DeployVdbDialog;
import org.teiid.designer.runtime.ui.vdb.VdbAgeChecker;
import org.teiid.designer.runtime.ui.vdb.VdbDeployer;
import org.teiid.designer.runtime.ui.vdb.VdbRequiresSaveChecker;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.XmiVdb;

public class DeployVdbAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(DeployVdbAction.class);
    private final Collection<IFile> selectedVDBs = new ArrayList<IFile>();
    Properties designerProperties;
    static String failedModelName = null;

    public DeployVdbAction() {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
    }

    public DeployVdbAction(Properties properties) {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
        this.designerProperties = properties;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public boolean isApplicable(ISelection selection) {
        List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
        if (objs.isEmpty()) {
            return false;
        }
        for (Object obj : objs) {
            if (obj instanceof IFile) {
                String extension = ((IFile)obj).getFileExtension();
                if (extension != null && extension.equals("vdb")) continue;
                return false;
            }
            return false;
        }
        ITeiidServer teiidServer = DeployVdbAction.getServerManager().getDefaultServer();
        return teiidServer != null;
    }

    public void run() {
        if (!this.checkForConnectedServer()) {
            return;
        }
        ITeiidServer teiidServer = DeployVdbAction.getServerManager().getDefaultServer();
        for (IFile nextVDB : this.selectedVDBs) {
            Shell shell;
            boolean doDeploy = VdbRequiresSaveChecker.insureOpenVdbSaved(nextVDB);
            if (doDeploy) {
                doDeploy = VdbAgeChecker.doDeploy(nextVDB, teiidServer.getServerVersion());
            }
            if (!doDeploy) continue;
            boolean deploySuccess = DeployVdbAction.deployVdb(teiidServer, nextVDB);
            String vdbName = FileUtils.getNameWithoutExtension((IResource)nextVDB);
            try {
                if (!teiidServer.hasVdb(vdbName)) {
                    deploySuccess = false;
                    break;
                }
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
                shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
                String title = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.title", new Object[]{vdbName, teiidServer});
                String message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.msg", new Object[]{vdbName, teiidServer});
                ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)new Status(4, "org.teiid.designer.dqp.ui", message, (Throwable)ex));
            }
            if (!deploySuccess) continue;
            try {
                CreateVdbDataSourceAction.doCreateDataSource(vdbName, teiidServer, true);
            }
            catch (Exception ex) {
                shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
                MessageDialog.openError((Shell)shell, (String)DqpUiConstants.UTIL.getString("CreateVdbDataSourceAction.errorCreatingDataSourceForVDB", (Object)vdbName), (String)ex.getMessage());
                DqpUiConstants.UTIL.log(4, (Throwable)ex, DqpUiConstants.UTIL.getString("CreateVdbDataSourceAction.errorCreatingDataSourceForVDB", (Object)vdbName));
            }
        }
    }

    public void queryUserAndRun() {
        if (!this.checkForConnectedServer()) {
            return;
        }
        ITeiidServer teiidServer = DeployVdbAction.getServerManager().getDefaultServer();
        DeployVdbDialog dialog = new DeployVdbDialog(DqpUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), this.designerProperties);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            IFile vdbFile = dialog.getSelectedVdb();
            boolean doCreateDS = dialog.doCreateVdbDataSource();
            String jndiName = dialog.getVdbDataSourceJndiName();
            if (vdbFile != null) {
                boolean doDeploy = VdbRequiresSaveChecker.insureOpenVdbSaved(vdbFile);
                if (doDeploy) {
                    DeployVdbAction.deployVdb(teiidServer, vdbFile, true);
                }
                String vdbName = FileUtils.getNameWithoutExtension((IResource)vdbFile);
                try {
                    if (teiidServer.hasVdb(vdbName) && doCreateDS) {
                        this.createVdbDataSource(vdbFile, jndiName, jndiName);
                    }
                }
                catch (Exception ex) {
                    DqpPlugin.Util.log((Throwable)ex);
                    Shell shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
                    String title = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.title", new Object[]{vdbName, teiidServer});
                    String message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.msg", new Object[]{vdbName, teiidServer});
                    ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)new Status(4, "org.teiid.designer.dqp.ui", message, (Throwable)ex));
                }
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.selectedVDBs.clear();
        boolean enable = this.isApplicable(selection);
        if (this.isEnabled() != enable) {
            this.setEnabled(enable);
        }
        if (this.isEnabled()) {
            List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
            this.selectedVDBs.addAll(objs);
        }
    }

    private boolean checkForConnectedServer() {
        ITeiidServer teiidServer = DeployVdbAction.getServerManager().getDefaultServer();
        if (teiidServer == null || !teiidServer.isConnected()) {
            Shell shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
            String title = DqpUiConstants.UTIL.getString("ActionRequiresServer.title", new Object[0]);
            String msg = DqpUiConstants.UTIL.getString("ActionRequiresServer.msg", new Object[0]);
            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
            return false;
        }
        return true;
    }

    private static ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }

    public static boolean deployVdb(ITeiidServer teiidServer, Object vdbOrVdbFile) {
        return DeployVdbAction.deployVdb(teiidServer, vdbOrVdbFile, DeployVdbAction.shouldAutoCreateDataSource());
    }

    public static boolean deployVdb(ITeiidServer teiidServer, Object vdbOrVdbFile, boolean doCreateDataSource) {
        block24: {
            VdbDeployer.DeployStatus status;
            VdbDeployer deployer;
            XmiVdb vdb;
            Shell shell;
            block23: {
                block22: {
                    block21: {
                        String msg;
                        String title;
                        block20: {
                            shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
                            if (!(vdbOrVdbFile instanceof IFile) && !(vdbOrVdbFile instanceof Vdb)) {
                                throw new IllegalArgumentException(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "selectionIsNotAVdb", new Object[0]));
                            }
                            if (teiidServer.isConnected()) break block20;
                            return false;
                        }
                        Object object = vdb = vdbOrVdbFile instanceof IFile ? new XmiVdb((IFile)vdbOrVdbFile) : (Vdb)vdbOrVdbFile;
                        if (vdb.isSynchronized() || MessageDialog.openQuestion((Shell)shell, (String)(title = DqpUiConstants.UTIL.getString("VdbNotSyncdDialog.title", new Object[0])), (String)(msg = DqpUiConstants.UTIL.getString("VdbNotSyncdDialog.msg", new Object[0])))) break block21;
                        return false;
                    }
                    if (VdbAgeChecker.doDeploy(vdb.getSourceFile(), teiidServer.getServerVersion())) break block22;
                    return false;
                }
                deployer = new VdbDeployer(shell, (Vdb)vdb, teiidServer, doCreateDataSource);
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                failedModelName = null;
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            failedModelName = deployer.deploy(monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                dialog.run(true, false, runnable);
                status = deployer.getStatus();
                if (!status.isError()) break block23;
                String message = null;
                if (VdbDeployer.DeployStatus.CREATE_DATA_SOURCE_FAILED == status) {
                    message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "createDataSourceFailed", new Object[]{deployer.getVdbName(), failedModelName});
                } else if (VdbDeployer.DeployStatus.DEPLOY_VDB_FAILED == status) {
                    message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "vdbFailedToDeploy", (Object)deployer.getVdbName());
                } else if (VdbDeployer.DeployStatus.TRANSLATOR_PROBLEM == status) {
                    message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "translatorDoesNotExistOnServer", (Object)deployer.getVdbName());
                } else if (VdbDeployer.DeployStatus.SOURCE_CONNECTION_INFO_PROBLEM == status) {
                    message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "sourceMissingConnectionInfo", (Object)deployer.getVdbName());
                } else {
                    if (VdbDeployer.DeployStatus.EXCEPTION == status) {
                        throw deployer.getException();
                    }
                    message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "unknownDeployError", new Object[]{deployer.getVdbName(), status});
                }
                MessageDialog.openError((Shell)shell, (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "vdbNotDeployedTitle", new Object[0]), (String)message);
                return false;
            }
            try {
                if (status.isDeployed()) {
                    if (teiidServer.wasVdbRemoved(deployer.getVdbName())) {
                        StringBuilder message = new StringBuilder(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "vdbNotActiveMessage", (Object)vdb.getName()));
                        for (String error : teiidServer.retrieveVdbValidityErrors(deployer.getVdbName())) {
                            message.append(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "notActiveErrorMessage", (Object)error));
                        }
                        MessageDialog.openWarning((Shell)shell, (String)DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "vdbNotActiveTitle", new Object[0]), (String)message.toString());
                        return true;
                    }
                    break block24;
                }
                return false;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getCause();
                }
                String vdbName = null;
                vdbName = vdbOrVdbFile instanceof IFile ? ((IFile)vdbOrVdbFile).getName() : (vdbOrVdbFile instanceof Vdb ? ((Vdb)vdbOrVdbFile).getName() : DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "selectionIsNotAVdb", new Object[0]));
                String message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbToServer", new Object[]{vdbName, teiidServer});
                DqpUiConstants.UTIL.log(e);
                ErrorDialog.openError((Shell)shell, (String)message, null, (IStatus)new Status(4, "org.teiid.designer.dqp.ui", message, e));
                return false;
            }
        }
        return true;
    }

    static boolean shouldAutoCreateDataSource() {
        return DqpPlugin.getInstance().getPreferences().getBoolean("org.teiid.designer.dqp.preferences.AutoCreateDataSource", true);
    }

    private void createVdbDataSource(Object vdbOrVdbFile, String displayName, String jndiName) throws Exception {
        XmiVdb vdb = vdbOrVdbFile instanceof IFile ? new XmiVdb((IFile)vdbOrVdbFile) : (Vdb)vdbOrVdbFile;
        ITeiidServer teiidServer = DeployVdbAction.getServerManager().getDefaultServer();
        String vdbName = vdb.getName();
        teiidServer.createVdbDataSource(vdbName, displayName, jndiName);
    }
}

