/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class SetConstraintCommand
extends Command {
    private EditPart targetEditPart;
    private Point newPos;
    private Dimension newSize;
    private Point oldPos;
    private Dimension oldSize;
    private DiagramModelNode m_model;

    public SetConstraintCommand(EditPart ep) {
        this.targetEditPart = ep;
    }

    public void execute() {
        this.oldSize = this.m_model.getSize();
        this.oldPos = new Point(this.m_model.getPosition());
        this.m_model.setPosition(this.newPos);
        this.m_model.setSize(this.newSize);
        if (this.targetEditPart.getViewer() != null) {
            ((DiagramViewer)this.targetEditPart.getViewer()).exposePart(this.targetEditPart);
        }
    }

    public void redo() {
        this.m_model.setSize(this.newSize);
        this.m_model.setPosition(this.newPos);
    }

    public void setLocation(Rectangle r) {
        this.setLocation(r.getLocation());
        this.setSize(r.getSize());
    }

    public void setLocation(Point p) {
        this.newPos = p;
    }

    public void setModel(DiagramModelNode iModel) {
        this.m_model = iModel;
    }

    public void setSize(Dimension p) {
        this.newSize = p;
    }

    public void undo() {
        this.m_model.setSize(this.oldSize);
        this.m_model.setPosition(this.oldPos);
    }
}

