/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.events.MouseEvent;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.editor.IDiagramSelectionHandler;
import org.teiid.designer.diagram.ui.figure.DiagramPolylineConnection;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;

public class ConnectionSelectionTracker
extends SelectEditPartTracker {
    private IDiagramSelectionHandler selectionHandler;
    private EditPart selectedEndEditPart;

    public ConnectionSelectionTracker(EditPart owner) {
        super(owner);
    }

    public ConnectionSelectionTracker(EditPart owner, IDiagramSelectionHandler selectionHandler) {
        super(owner);
        this.selectionHandler = selectionHandler;
    }

    protected boolean handleDoubleClick(int button) {
        if (this.getSourceEditPart() instanceof DiagramEditPart) {
            Request request = new Request((Object)"direct edit");
            this.getSourceEditPart().performRequest(request);
        }
        return true;
    }

    public void mouseDoubleClick(MouseEvent me, EditPartViewer viewer) {
        super.mouseDoubleClick(me, viewer);
    }

    protected void performSelection() {
        if (this.selectedEndEditPart != null) {
            if (this.hasSelectionOccurred()) {
                return;
            }
            this.setFlag(64, true);
            EditPartViewer viewer = this.getCurrentViewer();
            viewer.deselect(this.getSourceEditPart());
            this.selectionHandler.hiliteConnection((NodeConnectionEditPart)this.getSourceEditPart());
            this.selectionHandler.setClearHilites(false);
            viewer.select(this.selectedEndEditPart);
            this.selectionHandler.setClearHilites(true);
        } else {
            super.performSelection();
        }
    }

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        this.selectedEndEditPart = this.getEndEditPart(me, viewer);
        super.mouseDown(me, viewer);
    }

    private EditPart getEndEditPart(MouseEvent me, EditPartViewer viewer) {
        if (this.getSourceEditPart() instanceof NodeConnectionEditPart) {
            ZoomManager zm = (ZoomManager)((DiagramViewer)viewer).getEditor().getAdapter(ZoomManager.class);
            double zoomValue = zm.getZoom();
            int threshold = (int)(20.0 / zoomValue);
            int scrollX = ((DiagramViewer)viewer).getCurrentHScrollValue();
            int scrollY = ((DiagramViewer)viewer).getCurrentVScrollValue();
            DiagramPolylineConnection dpc = (DiagramPolylineConnection)((AbstractGraphicalEditPart)this.getSourceEditPart()).getFigure();
            Point p0 = new Point((double)(me.x + scrollX) / zoomValue, (double)(me.y + scrollY) / zoomValue);
            Point p1 = dpc.getStart();
            int deltaX = p0.x - p1.x;
            int deltaY = p0.y - p1.y;
            int dist = (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            if (dist < threshold) {
                return this.getSourceEndEditPart();
            }
            Point p2 = dpc.getEnd();
            deltaX = p0.x - p2.x;
            deltaY = p0.y - p2.y;
            dist = (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            if (dist < threshold) {
                return this.getTargetEndEditPart();
            }
        }
        return null;
    }

    private EditPart getSourceEndEditPart() {
        return DiagramUiUtilities.getSourceEndEditPart((NodeConnectionEditPart)this.getSourceEditPart());
    }

    private EditPart getTargetEndEditPart() {
        return DiagramUiUtilities.getTargetEndEditPart((NodeConnectionEditPart)this.getSourceEditPart());
    }
}

