/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DiagramDecoratorHandler {
    private DiagramEditor dEditor;
    private HashMap currentMarkerEObjectMap;

    public DiagramDecoratorHandler(DiagramEditor editor) {
        this.dEditor = editor;
    }

    public void initialize() {
        this.currentMarkerEObjectMap = new HashMap(this.getMarkersForDiagramResource(this.dEditor.getCurrentModel()));
    }

    public void reset() {
        this.initialize();
    }

    public void clear() {
        this.currentMarkerEObjectMap = new HashMap();
    }

    private HashMap getMarkersForDiagramResource(DiagramModelNode diagram) {
        HashMap<EObject, IMarker> newMap = new HashMap<EObject, IMarker>();
        if (diagram != null) {
            IMarker[] markers = null;
            IResource resrc = null;
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)diagram.getModelObject());
            if (modelResource != null && modelResource.exists()) {
                resrc = modelResource.getResource();
            }
            if (resrc != null) {
                boolean errorOccurred = false;
                try {
                    markers = resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
                }
                catch (CoreException ex) {
                    DiagramUiConstants.Util.log((Throwable)ex);
                    errorOccurred = true;
                }
                if (!errorOccurred) {
                    int ndx = markers.length;
                    while (--ndx >= 0) {
                        IMarker marker = markers[ndx];
                        EObject targetEObject = ModelWorkspaceManager.getModelWorkspaceManager().getMarkerManager().getMarkedEObject(resrc, marker);
                        if (targetEObject == null || newMap.get(targetEObject) != null) continue;
                        newMap.put(targetEObject, marker);
                    }
                }
            }
        }
        if (newMap.isEmpty()) {
            return new HashMap(1);
        }
        return newMap;
    }

    public void handleLabelProviderChanged() {
        HashMap newEObjectMap = this.getMarkersForDiagramResource(this.dEditor.getCurrentModel());
        HashMap updateableEObjects = new HashMap(newEObjectMap);
        if (this.currentMarkerEObjectMap != null && !this.currentMarkerEObjectMap.isEmpty()) {
            Iterator iter = this.currentMarkerEObjectMap.keySet().iterator();
            EObject nextEObject = null;
            while (iter.hasNext()) {
                nextEObject = (EObject)iter.next();
                if (newEObjectMap.get(nextEObject) != null || updateableEObjects.get(nextEObject) != null) continue;
                updateableEObjects.put(nextEObject, this.currentMarkerEObjectMap.get(nextEObject));
            }
        }
        this.currentMarkerEObjectMap = new HashMap(newEObjectMap);
        this.dEditor.getModelFactory().handleLabelProviderChanged(this.dEditor.getCurrentModel(), new ArrayList(updateableEObjects.keySet()));
    }

    public boolean handleResouceChanged() {
        DiagramModelNode currentDiagramNode = this.dEditor.getCurrentModel();
        boolean hasErrorOrWarning = DiagramUiUtilities.hasEObjectsWithErrorsOrWarnings(currentDiagramNode);
        if (hasErrorOrWarning) {
            return true;
        }
        HashMap currentMarkers = this.getMarkersForDiagramResource(currentDiagramNode);
        return !currentMarkers.isEmpty();
    }

    public int getErrorState(EObject eObj) {
        Object marker;
        int errorState = 0;
        if (this.currentMarkerEObjectMap == null) {
            this.initialize();
        }
        if ((marker = this.currentMarkerEObjectMap.get(eObj)) != null) {
            Object attr = MarkerUtilities.getMarkerAttribute((IMarker)((IMarker)marker), (String)"severity");
            if (attr != null) {
                int severity = (Integer)attr;
                if (severity == 2) {
                    errorState = 2;
                } else if (errorState == 0 && severity == 1) {
                    errorState = 1;
                }
            } else {
                this.currentMarkerEObjectMap.remove(eObj);
            }
        }
        return errorState;
    }
}

