/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.custom.CustomDiagramModelFactory;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RemoveFromDiagramAction
extends DiagramAction {
    private static final String THIS_CLASS = "RemoveFromDiagramAction";
    private DiagramEditor editor;

    public RemoveFromDiagramAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_remove_from_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(this.shouldEnable());
    }

    @Override
    protected void doRun() {
        if (this.editor != null) {
            DiagramModelNode diagramNode = this.editor.getCurrentModel();
            Diagram diagram = (Diagram)diagramNode.getModelObject();
            CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)this.editor.getModelFactory();
            if (modelFactory != null) {
                boolean handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction(diagram);
                boolean requiredStart = false;
                boolean succeeded = false;
                try {
                    try {
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramUnderConstruction(diagram);
                        }
                        requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Add To Custom Diagram", (Object)((Object)this));
                        modelFactory.remove(SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()), diagramNode);
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".doRun()");
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                        }
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                    }
                }
            }
        }
    }

    private boolean shouldEnable() {
        if (!(this.getPart() instanceof ModelEditor) || this.getSelection() == null || SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).size() < 0) {
            return false;
        }
        return this.allSelectedInDiagram() && this.isWritable();
    }

    private boolean allSelectedInDiagram() {
        if (this.editor != null && this.editor.getDiagramViewer() != null && this.editor.getDiagramViewer().getSelectionHandler() != null) {
            List selectedEObjects = this.editor.getDiagramViewer().getSelectionHandler().getSelectedEObjects();
            if (selectedEObjects == null || selectedEObjects.isEmpty()) {
                return false;
            }
            Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).iterator();
            EObject eObj = null;
            while (iter.hasNext()) {
                eObj = (EObject)iter.next();
                if (selectedEObjects.contains(eObj)) continue;
                return false;
            }
        }
        return true;
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.editor = editor;
    }

    private boolean isWritable() {
        EObject diagram;
        DiagramModelNode currentDiagram;
        return this.editor != null && (currentDiagram = this.editor.getCurrentModel()) != null && !ModelObjectUtilities.isReadOnly((EObject)(diagram = currentDiagram.getModelObject()));
    }

    protected boolean preRun() {
        EObject eObject;
        ModelResource mr;
        List allSelectedEObjects;
        if (this.requiresEditorForRun() && (allSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection())) != null && !allSelectedEObjects.isEmpty() && (mr = ModelUtilities.getModelResourceForModelObject((EObject)(eObject = (EObject)allSelectedEObjects.get(0)))) != null) {
            ModelEditorManager.activate((ModelResource)mr, (boolean)false);
        }
        return true;
    }
}

