/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class NewCustomDiagramSiblingAction
extends DiagramAction
implements DiagramUiConstants {
    private static final boolean PERSIST_CUSTOM_DIAGRAMS = true;

    public NewCustomDiagramSiblingAction() {
    }

    public NewCustomDiagramSiblingAction(int theStyle) {
        super(theStyle);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        block14: {
            EObject selectedEObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
            boolean requiredStart = false;
            boolean succeeded = false;
            try {
                try {
                    requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"New Custom Diagram", (Object)this);
                    this.createDiagram(selectedEObject);
                    succeeded = true;
                }
                catch (ModelWorkspaceException ex) {
                    String message = Util.getString("NewCustomDiagramSiblingAction.createCustomDiagramError", (Object)selectedEObject.toString());
                    Util.log(4, (Throwable)ex, message);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.determineEnablement();
    }

    private void createDiagram(EObject selectedEObject) throws ModelWorkspaceException {
        ModelResource modelResource;
        if (selectedEObject != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)selectedEObject)) != null) {
            EObject eObject = null;
            if (!(selectedEObject instanceof Diagram)) {
                eObject = selectedEObject.eContainer();
            } else {
                EObject target = ((Diagram)selectedEObject).getTarget();
                if (!(target instanceof ModelAnnotation)) {
                    eObject = target;
                }
            }
            Diagram result = modelResource.getModelDiagrams().createNewDiagram(eObject, true);
            result.setType("customDiagramType");
        }
    }

    private void determineEnablement() {
        ModelResource modelResource;
        EObject selectedEObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (selectedEObject != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)selectedEObject)) != null && !modelResource.isReadOnly()) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    protected boolean preRun() {
        ModelResource modelResource;
        EObject selectedEObject;
        if (this.requiresEditorForRun() && (selectedEObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection())) != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)selectedEObject)) != null) {
            ModelEditorManager.activate((ModelResource)modelResource, (boolean)true);
        }
        return true;
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }
}

