/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.metamodel.aspect.uml.UmlDependency;
import org.teiid.designer.core.metamodel.aspect.uml.UmlRelationship;
import org.teiid.designer.diagram.ui.connection.BinaryAssociation;
import org.teiid.designer.diagram.ui.connection.DiagramUmlAssociation;
import org.teiid.designer.diagram.ui.connection.DiagramUmlDependency;
import org.teiid.designer.diagram.ui.connection.DiagramUmlGeneralization;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.connection.UmlAssociationBass;
import org.teiid.designer.diagram.ui.connection.UmlDependencyBass;
import org.teiid.designer.diagram.ui.connection.UmlGeneralizationBass;
import org.teiid.designer.diagram.ui.connection.UmlRelationshipHelper;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;

public class UmlRelationshipFactory {
    public static List getBinaryAssociations(EObject relationshipEObject, EObject sourceEObject) {
        ArrayList<BinaryAssociation> assList = new ArrayList<BinaryAssociation>();
        int type = UmlRelationshipHelper.getType(relationshipEObject);
        switch (type) {
            case 0: {
                BinaryAssociation newAss = UmlRelationshipFactory.createUmlAssociation(relationshipEObject);
                if (newAss == null) break;
                assList.add(newAss);
                break;
            }
            case 1: {
                assList.addAll(UmlRelationshipFactory.createUmlDependencies(relationshipEObject));
                break;
            }
            case 2: {
                BinaryAssociation newAss = UmlRelationshipFactory.createUmlGeneralization(relationshipEObject);
                if (newAss == null) break;
                assList.add(newAss);
            }
        }
        return assList;
    }

    public static BinaryAssociation createUmlAssociation(EObject relationshipEObject) {
        return new UmlAssociationBass(relationshipEObject);
    }

    public static List createUmlDependencies(EObject relationshipEObject) {
        ArrayList<UmlDependencyBass> assList = new ArrayList<UmlDependencyBass>(1);
        UmlRelationship theAspect = UmlRelationshipHelper.getRelationshipAspect(relationshipEObject);
        if (theAspect != null) {
            UmlDependency depAspect = (UmlDependency)theAspect;
            Iterator sourceIter = depAspect.getSource((Object)relationshipEObject).iterator();
            Iterator targetIter = null;
            EObject sourceEObject = null;
            EObject targetEObject2 = null;
            while (sourceIter.hasNext()) {
                sourceEObject = (EObject)sourceIter.next();
                for (EObject targetEObject2 : depAspect.getTarget((Object)relationshipEObject)) {
                    assList.add(new UmlDependencyBass(relationshipEObject, sourceEObject, targetEObject2));
                }
            }
        }
        return assList;
    }

    public static BinaryAssociation createUmlGeneralization(EObject relationshipEObject) {
        return new UmlGeneralizationBass(relationshipEObject);
    }

    public static BinaryAssociation createUmlGeneralization(EObject sourceEObject, EObject targetEObject) {
        return new UmlGeneralizationBass(sourceEObject, sourceEObject, targetEObject);
    }

    public static List getBinaryAssociations(List relationshipList, EObject sourceEObject) {
        ArrayList<BinaryAssociation> finalList = new ArrayList<BinaryAssociation>();
        Iterator iter = relationshipList.iterator();
        Object nextObject = null;
        EObject nextEObject = null;
        BinaryAssociation nextBass2 = null;
        while (iter.hasNext()) {
            List tempList;
            nextObject = iter.next();
            if (!(nextObject instanceof EObject) || (tempList = UmlRelationshipFactory.getBinaryAssociations(nextEObject = (EObject)nextObject, sourceEObject)) == null || tempList.isEmpty()) continue;
            for (BinaryAssociation nextBass2 : tempList) {
                if (UmlRelationshipFactory.relationshipExists(finalList, nextBass2)) continue;
                finalList.add(nextBass2);
            }
        }
        return finalList;
    }

    public static NodeConnectionModel getConnectionModel(BinaryAssociation bAss, DiagramModelNode diagramRootModelObject, HashMap nodeMap) {
        DiagramUmlAssociation newConnectionModel = null;
        switch (bAss.getRelationshipType()) {
            case 0: {
                EObject sourceObject = bAss.getEndTarget(0);
                EObject targetObject = bAss.getEndTarget(1);
                if (sourceObject == null || targetObject == null || sourceObject.equals(targetObject)) break;
                DiagramModelNode sourceNode = null;
                DiagramModelNode targetNode = null;
                if (nodeMap != null && !nodeMap.isEmpty()) {
                    sourceNode = (DiagramModelNode)nodeMap.get(sourceObject);
                    targetNode = (DiagramModelNode)nodeMap.get(targetObject);
                } else {
                    sourceNode = DiagramUiUtilities.getModelNode(sourceObject, diagramRootModelObject);
                    targetNode = DiagramUiUtilities.getModelNode(targetObject, diagramRootModelObject);
                }
                if (sourceNode == null || targetNode == null) break;
                DiagramModelNode sourceClassifierNode = DiagramUiUtilities.getTopClassifierParentNode(sourceNode);
                DiagramModelNode targetClassifierNode = DiagramUiUtilities.getTopClassifierParentNode(targetNode);
                if (sourceClassifierNode == null || targetClassifierNode == null) break;
                newConnectionModel = new DiagramUmlAssociation(sourceClassifierNode, targetClassifierNode, bAss);
                break;
            }
            case 1: {
                EObject sourceObject = bAss.getEnd(0);
                EObject targetObject = bAss.getEnd(1);
                if (sourceObject == null || targetObject == null || sourceObject.equals(targetObject)) break;
                DiagramModelNode sourceNode = DiagramUiUtilities.getModelNode(sourceObject, diagramRootModelObject);
                DiagramModelNode targetNode = DiagramUiUtilities.getModelNode(targetObject, diagramRootModelObject);
                if (sourceNode == null || targetNode == null) break;
                DiagramModelNode sourceClassifierNode = DiagramUiUtilities.getTopClassifierParentNode(sourceNode);
                DiagramModelNode targetClassifierNode = DiagramUiUtilities.getTopClassifierParentNode(targetNode);
                if (sourceClassifierNode == null || targetClassifierNode == null) break;
                newConnectionModel = new DiagramUmlDependency(sourceClassifierNode, targetClassifierNode, bAss);
                break;
            }
            case 2: {
                EObject sourceObject = bAss.getEnd(0);
                EObject targetObject = bAss.getEnd(1);
                if (sourceObject == null || targetObject == null || sourceObject.equals(targetObject)) break;
                DiagramModelNode sourceNode = DiagramUiUtilities.getModelNode(sourceObject, diagramRootModelObject);
                DiagramModelNode targetNode = DiagramUiUtilities.getModelNode(targetObject, diagramRootModelObject);
                if (sourceNode == null || targetNode == null) break;
                DiagramModelNode sourceClassifierNode = DiagramUiUtilities.getTopClassifierParentNode(sourceNode);
                DiagramModelNode targetClassifierNode = DiagramUiUtilities.getTopClassifierParentNode(targetNode);
                if (sourceClassifierNode == null || targetClassifierNode == null) break;
                newConnectionModel = new DiagramUmlGeneralization(sourceClassifierNode, targetClassifierNode, bAss);
                break;
            }
        }
        return newConnectionModel;
    }

    private static boolean relationshipExists(List currentAssList, BinaryAssociation newBass) {
        Iterator iter = currentAssList.iterator();
        BinaryAssociation nextBass = null;
        while (iter.hasNext()) {
            nextBass = (BinaryAssociation)iter.next();
            if (!newBass.equals(nextBass)) continue;
            return true;
        }
        return false;
    }

    public static boolean relationshipExistsInDiagram(DiagramModelNode diagramNode, BinaryAssociation someBass) {
        ArrayList allConnections = new ArrayList(DiagramUiUtilities.getAllSourceConnections(diagramNode));
        ArrayList<BinaryAssociation> bassList = new ArrayList<BinaryAssociation>(allConnections.size());
        Iterator iter = allConnections.iterator();
        Object nextObject = null;
        DiagramUmlAssociation nextConnectionNode = null;
        BinaryAssociation nextBass = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof DiagramUmlAssociation) || (nextBass = (nextConnectionNode = (DiagramUmlAssociation)nextObject).getBAssociation()) == null || bassList.contains(nextBass)) continue;
            bassList.add(nextBass);
        }
        return UmlRelationshipFactory.relationshipExists(bassList, someBass);
    }
}

