/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.ZoomableEditor;
import org.teiid.designer.ui.editors.ModelEditor;

public class ZoomComboActionContributeItem
extends ActionContributionItem
implements ZoomListener {
    private Combo combo;
    private String initString = "100%";
    private ToolItem toolitem;
    private ZoomManager zoomManager;
    private IPartService service;
    private IPartListener partListener;
    boolean isListening;
    private boolean thisIsSource = false;

    public ZoomComboActionContributeItem(IAction action, IPartService partService) {
        super(action);
        this.service = partService;
        Assert.isNotNull((Object)partService);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (!ZoomComboActionContributeItem.this.isListening && ZoomComboActionContributeItem.this.getZoomManager() != null) {
                    ZoomComboActionContributeItem.this.getZoomManager().addZoomListener(ZoomComboActionContributeItem.this.getThis());
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
                if (ZoomComboActionContributeItem.this.isListening && ZoomComboActionContributeItem.this.getZoomManager() != null) {
                    ZoomComboActionContributeItem.this.getZoomManager().removeZoomListener(ZoomComboActionContributeItem.this.getThis());
                }
                ZoomComboActionContributeItem.this.isListening = false;
            }

            public void partDeactivated(IWorkbenchPart p) {
                if (ZoomComboActionContributeItem.this.isListening && ZoomComboActionContributeItem.this.getZoomManager() != null) {
                    ZoomComboActionContributeItem.this.getZoomManager().removeZoomListener(ZoomComboActionContributeItem.this.getThis());
                }
                ZoomComboActionContributeItem.this.isListening = false;
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    public ZoomComboActionContributeItem(IAction action) {
        super(action);
    }

    ZoomListener getThis() {
        return this;
    }

    public ZoomComboActionContributeItem(IAction action, IPartService partService, String initString) {
        super(action);
        this.initString = initString;
        this.service = partService;
        Assert.isNotNull((Object)partService);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (!ZoomComboActionContributeItem.this.isListening) {
                    ZoomComboActionContributeItem.this.getZoomManager().addZoomListener(ZoomComboActionContributeItem.this.getThis());
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
                if (ZoomComboActionContributeItem.this.isListening) {
                    ZoomComboActionContributeItem.this.getZoomManager().removeZoomListener(ZoomComboActionContributeItem.this.getThis());
                }
                ZoomComboActionContributeItem.this.isListening = false;
            }

            public void partDeactivated(IWorkbenchPart p) {
                if (ZoomComboActionContributeItem.this.isListening) {
                    ZoomComboActionContributeItem.this.getZoomManager().removeZoomListener(ZoomComboActionContributeItem.this.getThis());
                }
                ZoomComboActionContributeItem.this.isListening = false;
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    void refresh(ZoomManager zm) {
        block7: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (zm == null) {
                    this.combo.setEnabled(false);
                    this.combo.removeAll();
                } else {
                    this.combo.setItems(zm.getZoomLevelsAsText());
                    String zoom = zm.getZoomAsText();
                    int index = this.combo.indexOf(zoom);
                    if (index != -1) {
                        this.combo.select(index);
                    } else {
                        this.combo.setText(zoom);
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block7;
                throw exception;
            }
        }
    }

    private ModelEditor getActiveEditor() {
        IEditorPart editor;
        IWorkbenchPage activePage = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (editor = activePage.getActiveEditor()) instanceof ModelEditor) {
            return (ModelEditor)editor;
        }
        return null;
    }

    private DiagramEditor getDiagramEditor() {
        DiagramEditor deEditorPage;
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && editor.getCurrentPage() instanceof ZoomableEditor && (deEditorPage = ((ZoomableEditor)editor.getCurrentPage()).getDiagramEditor()) != null) {
            return deEditorPage;
        }
        return null;
    }

    ZoomManager getZoomManager() {
        DiagramEditor deEditorPage;
        ZoomManager zm = null;
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && editor.getCurrentPage() instanceof ZoomableEditor && (deEditorPage = ((ZoomableEditor)editor.getCurrentPage()).getDiagramEditor()) != null) {
            zm = (ZoomManager)deEditorPage.getAdapter(ZoomManager.class);
        }
        return zm;
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ZoomComboActionContributeItem.this.handleWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ZoomComboActionContributeItem.this.handleWidgetDefaultSelected(e);
            }
        });
        this.combo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ZoomComboActionContributeItem.this.dispose();
            }
        });
        this.combo.setItems(DiagramUiConstants.Zoom.zoomStrings);
        this.combo.setText(this.initString);
        this.toolitem.setWidth(80);
        this.combo.setToolTipText(this.getAction().getToolTipText());
        return this.combo;
    }

    public void dispose() {
        if (this.partListener == null) {
            return;
        }
        this.service.removePartListener(this.partListener);
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
            this.zoomManager = null;
        }
        this.combo = null;
        this.partListener = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.isTrue((boolean)false, (String)"Can't add a control to a menu");
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    void handleWidgetDefaultSelected(SelectionEvent event) {
        this.thisIsSource = true;
        ZoomManager zm = this.getZoomManager();
        zm.setZoomAsText(this.combo.getText());
        DiagramEditor de = this.getDiagramEditor();
        if (de != null) {
            de.handleZoomChanged();
        }
        this.thisIsSource = false;
        this.refresh(zm);
    }

    void handleWidgetSelected(SelectionEvent event) {
        this.thisIsSource = true;
        ZoomManager zm = this.getZoomManager();
        zm.setZoomAsText(this.combo.getText());
        DiagramEditor de = this.getDiagramEditor();
        if (de != null) {
            de.handleZoomChanged();
        }
        this.thisIsSource = false;
        this.refresh(zm);
    }

    public void zoomChanged(double zoom) {
        if (!this.thisIsSource && this.combo != null && !this.combo.isDisposed()) {
            String zoomString = (int)(zoom * 100.0) + "%";
            this.combo.setText(zoomString);
            this.combo.setEnabled(true);
        }
    }

    public void refreshText() {
        DiagramEditor de = this.getDiagramEditor();
        if (de != null) {
            this.zoomChanged(de.getCurrentZoomFactor());
        }
    }
}

