/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.actions.RouterTypeAction;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;

public class RouterTypeMenuManager
extends MenuManager
implements DiagramUiConstants.LinkRouter {
    private static final String LABEL = DiagramUiConstants.Util.getString("LinkSelectionAction.label", new Object[0]);
    private RouterTypeAction directAction;
    private RouterTypeAction orthogonalAction;
    private RouterTypeAction manualAction;
    private boolean singleLinkEdit = false;

    public RouterTypeMenuManager() {
        super(LABEL, "LinkSelectionAction");
        this.createMenu();
    }

    public void createMenu() {
        int currentIndex = DiagramEditorUtil.getCurrentDiagramRouterStyle();
        String actionString = DiagramUiConstants.Util.getString("LinkSelectionAction.direct", new Object[0]);
        this.directAction = new RouterTypeAction(actionString, 1, this);
        this.directAction.setToolTipText(actionString);
        this.directAction.setEnabled(true);
        this.directAction.setChecked(true);
        this.addActionToMenu((Action)this.directAction);
        actionString = DiagramUiConstants.Util.getString("LinkSelectionAction.orthogonal", new Object[0]);
        this.orthogonalAction = new RouterTypeAction(actionString, 0, this);
        this.orthogonalAction.setToolTipText(actionString);
        this.orthogonalAction.setEnabled(true);
        this.orthogonalAction.setChecked(true);
        this.addActionToMenu((Action)this.orthogonalAction);
        actionString = DiagramUiConstants.Util.getString("LinkSelectionAction.manual", new Object[0]);
        this.manualAction = new RouterTypeAction(actionString, 2, this);
        this.manualAction.setToolTipText(actionString);
        this.manualAction.setEnabled(true);
        this.manualAction.setChecked(true);
        this.addActionToMenu((Action)this.manualAction);
        if (currentIndex != 2) {
            this.manualAction.setChecked(false);
        }
        if (currentIndex != 0) {
            this.orthogonalAction.setChecked(false);
        }
        if (currentIndex != 1) {
            this.directAction.setChecked(false);
        }
    }

    protected void addActionToMenu(Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        this.add((IContributionItem)item);
    }

    public void handleSelection(int index, boolean initialSet) {
        switch (index) {
            case 1: {
                this.directAction.setChecked(true);
                this.manualAction.setChecked(false);
                this.orthogonalAction.setChecked(false);
                DiagramEditorUtil.setCurrentDiagramRouterStyle(index);
                break;
            }
            case 0: {
                this.orthogonalAction.setChecked(true);
                this.manualAction.setChecked(false);
                this.directAction.setChecked(false);
                DiagramEditorUtil.setCurrentDiagramRouterStyle(index);
                break;
            }
            case 2: {
                this.manualAction.setChecked(true);
                this.directAction.setChecked(false);
                this.orthogonalAction.setChecked(false);
                DiagramEditorUtil.setCurrentDiagramRouterStyle(index);
            }
        }
    }

    public void setInitialSelection() {
        int index = DiagramEditorUtil.getCurrentDiagramRouterStyle();
        this.handleSelection(index, true);
    }

    public boolean isSingleLinkEdit() {
        return this.singleLinkEdit;
    }

    public void setSingleLinkEdit(boolean singleLinkEdit) {
        this.singleLinkEdit = singleLinkEdit;
    }

    public void setEnabled(boolean enabled) {
        this.directAction.setEnabled(enabled);
        this.orthogonalAction.setEnabled(enabled);
        this.manualAction.setEnabled(enabled);
    }
}

