/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.AttributeInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.EditElementsPanel;
import org.teiid.designer.query.proc.wsdl.IWsdlAttributeInfo;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ElementsInfoPanel {
    private ProcedureInfo procedureInfo;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    EditElementsPanel editElementsPanel;
    private int type = -1;
    final OperationsDetailsPage detailsPage;

    public ElementsInfoPanel(Composite parent, int style, int type, OperationsDetailsPage detailsPage) {
        this.type = type;
        this.detailsPage = detailsPage;
        this.init(parent);
    }

    public ProcedureInfo getProcedureInfo() {
        return this.procedureInfo;
    }

    public void setProcedureInfo(ProcedureInfo info) {
        this.procedureInfo = info;
        this.editElementsPanel.setProcedureInfo(info);
        this.editElementsPanel.refresh();
        this.addButton.setEnabled(info != null);
    }

    public void refresh() {
        this.editElementsPanel.refresh();
    }

    private void init(Composite parent) {
        Group columnInfoGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.ElementInfo, (int)0, (int)2, (int)2);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        columnInfoGroup.setLayoutData((Object)gd);
        Composite leftToolbarPanel = new Composite((Composite)columnInfoGroup, 0);
        GridLayout tbGL = new GridLayout();
        tbGL.marginHeight = 0;
        tbGL.marginWidth = 0;
        tbGL.verticalSpacing = 2;
        leftToolbarPanel.setLayout((Layout)tbGL);
        GridData ltpGD = new GridData(1040);
        ltpGD.heightHint = 120;
        leftToolbarPanel.setLayoutData((Object)ltpGD);
        this.addButton = new Button(leftToolbarPanel, 8);
        this.addButton.setText(Messages.Add);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok;
                String name = ElementsInfoPanel.this.detailsPage.createRequestColumn(ElementsInfoPanel.this.type);
                if (name != null && (ok = MessageDialog.openQuestion((Shell)ElementsInfoPanel.this.detailsPage.getShell(), (String)Messages.InvalidSelectedSchemaObject, (String)NLS.bind((String)Messages.InvalidSelectedSchemaObject_element_msg, (Object)name)))) {
                    if (ElementsInfoPanel.this.type == 0) {
                        ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().addBodyColumn(name, false, "string", null, null, null);
                    } else {
                        ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().addHeaderColumn(name, false, "string", null, null, null);
                    }
                    ElementsInfoPanel.this.editElementsPanel.refresh();
                    ElementsInfoPanel.this.notifyColumnDataChanged();
                }
            }
        });
        this.deleteButton = new Button(leftToolbarPanel, 8);
        this.deleteButton.setText(Messages.Delete);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeInfo info;
                Object selectedObject = ElementsInfoPanel.this.editElementsPanel.getSelectedObject();
                if (selectedObject instanceof ColumnInfo) {
                    ColumnInfo info2 = (ColumnInfo)selectedObject;
                    if (info2 != null) {
                        if (ElementsInfoPanel.this.type == 0) {
                            ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().removeBodyColumn(info2);
                        } else {
                            ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().removeHeaderColumn(info2);
                        }
                        ElementsInfoPanel.this.deleteButton.setEnabled(false);
                        ElementsInfoPanel.this.editElementsPanel.selectRow(-1);
                        ElementsInfoPanel.this.editElementsPanel.refresh();
                        ElementsInfoPanel.this.notifyColumnDataChanged();
                    }
                } else if (selectedObject instanceof IWsdlAttributeInfo && (info = (AttributeInfo)selectedObject) != null) {
                    ColumnInfo parentColumnInfo = info.getColumnInfo();
                    parentColumnInfo.removeAttributeInfo(info);
                    ElementsInfoPanel.this.deleteButton.setEnabled(false);
                    ElementsInfoPanel.this.editElementsPanel.selectRow(-1);
                    ElementsInfoPanel.this.editElementsPanel.refresh();
                    ElementsInfoPanel.this.notifyColumnDataChanged();
                }
            }
        });
        this.upButton = new Button(leftToolbarPanel, 8);
        this.upButton.setText(Messages.Up);
        this.upButton.setLayoutData((Object)new GridData(768));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnInfo info = ElementsInfoPanel.this.editElementsPanel.getSelectedColumn();
                if (info != null) {
                    int selectedIndex = ElementsInfoPanel.this.editElementsPanel.getSelectedIndex();
                    if (ElementsInfoPanel.this.type == 0) {
                        ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().moveBodyColumnUp(info);
                        ElementsInfoPanel.this.downButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveBodyColumnDown(info));
                        ElementsInfoPanel.this.upButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveBodyColumnUp(info));
                    } else {
                        ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().moveHeaderColumnUp(info);
                        ElementsInfoPanel.this.downButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveHeaderColumnDown(info));
                        ElementsInfoPanel.this.upButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveHeaderColumnUp(info));
                    }
                    ElementsInfoPanel.this.editElementsPanel.refresh();
                    ElementsInfoPanel.this.notifyColumnDataChanged();
                    ElementsInfoPanel.this.editElementsPanel.selectRow(selectedIndex - 1);
                }
            }
        });
        this.downButton = new Button(leftToolbarPanel, 8);
        this.downButton.setText(Messages.Down);
        this.downButton.setLayoutData((Object)new GridData(768));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnInfo info = ElementsInfoPanel.this.editElementsPanel.getSelectedColumn();
                if (info != null) {
                    int selectedIndex = ElementsInfoPanel.this.editElementsPanel.getSelectedIndex();
                    if (ElementsInfoPanel.this.type == 0) {
                        ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().moveBodyColumnDown(info);
                        ElementsInfoPanel.this.downButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveBodyColumnDown(info));
                        ElementsInfoPanel.this.upButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveBodyColumnUp(info));
                    } else {
                        ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().moveHeaderColumnDown(info);
                        ElementsInfoPanel.this.downButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveHeaderColumnDown(info));
                        ElementsInfoPanel.this.upButton.setEnabled(ElementsInfoPanel.this.detailsPage.getProcedureGenerator().getRequestInfo().canMoveHeaderColumnUp(info));
                    }
                    ElementsInfoPanel.this.editElementsPanel.refresh();
                    ElementsInfoPanel.this.notifyColumnDataChanged();
                    ElementsInfoPanel.this.editElementsPanel.selectRow(selectedIndex + 1);
                }
            }
        });
        this.editElementsPanel = new EditElementsPanel((Composite)columnInfoGroup, 0, this.type, this.detailsPage);
        this.editElementsPanel.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ElementsInfoPanel.this.deleteButton.setEnabled(false);
                ElementsInfoPanel.this.upButton.setEnabled(false);
                ElementsInfoPanel.this.downButton.setEnabled(false);
                if (!sel.isEmpty()) {
                    Object[] objs = sel.toArray();
                    if (objs[0] instanceof ColumnInfo) {
                        boolean enable = true;
                        ColumnInfo columnInfo = (ColumnInfo)objs[0];
                        ElementsInfoPanel.this.deleteButton.setEnabled(true);
                        if (enable) {
                            if (ElementsInfoPanel.this.type == 0) {
                                ElementsInfoPanel.this.upButton.setEnabled(ElementsInfoPanel.this.procedureInfo.canMoveBodyColumnUp(columnInfo));
                                ElementsInfoPanel.this.downButton.setEnabled(ElementsInfoPanel.this.procedureInfo.canMoveBodyColumnDown(columnInfo));
                            } else {
                                ElementsInfoPanel.this.upButton.setEnabled(ElementsInfoPanel.this.procedureInfo.canMoveHeaderColumnUp(columnInfo));
                                ElementsInfoPanel.this.downButton.setEnabled(ElementsInfoPanel.this.procedureInfo.canMoveHeaderColumnDown(columnInfo));
                            }
                        }
                    } else if (objs[0] instanceof IWsdlAttributeInfo) {
                        ElementsInfoPanel.this.deleteButton.setEnabled(true);
                    }
                }
            }
        });
    }

    private void notifyColumnDataChanged() {
        this.detailsPage.notifyColumnDataChanged();
    }

    public void disableButtons() {
        this.deleteButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    public void setEnabled(boolean enable) {
        this.addButton.setEnabled(enable);
        this.disableButtons();
        this.editElementsPanel.setEnabled(enable);
    }
}

