/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;
import org.teiid.designer.modelgenerator.wsdl.ui.util.ModelGeneratorWsdlUiUtil;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.AttributeInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlAttributeInfo;

public class EditElementsPanel {
    private final Image XSD_ELEMENT_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/xsd-element.gif");
    private final Image XSD_ATTRIBUTE_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/xsd-attribute.gif");
    TreeViewer columnsViewer;
    ProcedureInfo procedureInfo;
    int type;
    TreeEditor treeEditor;
    Text textEditor;
    Composite textEditorParent;
    TextActionHandler textActionHandler;
    Object selectedObject;
    TreeItem[] cachedSelection;
    final OperationsDetailsPage detailsPage;

    public EditElementsPanel(Composite parent, int style, int type, OperationsDetailsPage detailsPage) {
        this.type = type;
        this.detailsPage = detailsPage;
        this.createPanel(parent);
    }

    public ProcedureInfo getProcedureInfo() {
        return this.procedureInfo;
    }

    public void setProcedureInfo(ProcedureInfo info) {
        this.procedureInfo = info;
        this.columnsViewer.setInput((Object)this.procedureInfo);
        this.refresh();
    }

    private void createPanel(Composite parent) {
        Tree table = new Tree(parent, 2820);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 80;
        table.setLayoutData((Object)gd);
        this.columnsViewer = new TreeViewer(table);
        this.columnsViewer.getControl().setLayoutData((Object)gd);
        this.treeEditor = new TreeEditor(this.columnsViewer.getTree());
        ColumnDataTreeProvider provider = new ColumnDataTreeProvider();
        this.columnsViewer.setContentProvider((IContentProvider)provider);
        this.columnsViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.columnsViewer.setAutoExpandLevel(3);
        this.columnsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditElementsPanel.this.renameInline();
            }
        });
        this.columnsViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent theEvent) {
                if (theEvent.button == 1 && EditElementsPanel.this.isTextEditorActive() && EditElementsPanel.this.selectedObject != null) {
                    EditElementsPanel.this.saveChangesAndDispose(EditElementsPanel.this.selectedObject);
                }
            }
        });
    }

    public void refresh() {
        this.columnsViewer.refresh();
        this.columnsViewer.expandAll();
    }

    public void refresh(Object element) {
        this.columnsViewer.refresh(element);
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.columnsViewer.addSelectionChangedListener(listener);
    }

    public Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.columnsViewer.getSelection();
        Object[] objectArray = selection.toArray();
        if (objectArray.length != 0) {
            Object obj = objectArray[0];
            return obj;
        }
        return null;
    }

    public ColumnInfo getSelectedColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.columnsViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ColumnInfo) {
                return (ColumnInfo)obj;
            }
            ++n2;
        }
        return null;
    }

    public int getSelectedIndex() {
        TreeItem[] selectedItems = this.columnsViewer.getTree().getSelection();
        if (selectedItems.length > 0) {
            int i = 0;
            TreeItem[] treeItemArray = this.columnsViewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (selectedItems[0] == item) {
                    return i;
                }
                ++n2;
            }
        }
        return -1;
    }

    public void selectRow(int index) {
        if (index > -1) {
            TreeItem item = this.columnsViewer.getTree().getItem(index);
            this.columnsViewer.getTree().select(item);
        } else {
            this.columnsViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    private void notifyColumnDataChanged() {
        this.detailsPage.notifyColumnDataChanged();
    }

    public void setEnabled(boolean enable) {
        this.columnsViewer.getTree().setEnabled(enable);
    }

    private void renameInline() {
        Object obj;
        this.selectedObject = obj = this.getSelectedObject();
        this.cachedSelection = this.columnsViewer.getTree().getSelection();
        if (this.textEditorParent == null) {
            this.createTextEditor(obj);
        }
        String name = null;
        if (obj instanceof ColumnInfo) {
            name = ((ColumnInfo)obj).getName();
        } else if (obj instanceof IWsdlAttributeInfo) {
            name = ((IWsdlAttributeInfo)obj).getAlias();
        }
        if (name != null) {
            this.textEditor.setText(name);
        }
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    private void createTextEditor(final Object obj) {
        this.textEditorParent = this.createEditorParent();
        this.textEditorParent.setVisible(false);
        this.textEditorParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = EditElementsPanel.this.textEditor.getSize();
                Point parentSize = EditElementsPanel.this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = EditElementsPanel.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = EditElementsPanel.this.textEditorParent.getSize();
                EditElementsPanel.this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                EditElementsPanel.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        EditElementsPanel.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        EditElementsPanel.this.saveChangesAndDispose(obj);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    Composite createEditorParent() {
        Tree tree = this.columnsViewer.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = this.cachedSelection;
        if (selectedItems.length > 0) {
            this.treeEditor.horizontalAlignment = 16384;
            this.treeEditor.grabHorizontal = true;
            this.treeEditor.setEditor((Control)result, selectedItems[0]);
        }
        return result;
    }

    boolean isTextEditorActive() {
        return this.textEditor != null;
    }

    void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    void saveChangesAndDispose(Object obj) {
        String newName = this.textEditor.getText();
        if (obj instanceof ColumnInfo) {
            ((ColumnInfo)obj).setName(newName);
        } else if (obj instanceof IWsdlAttributeInfo) {
            ((AttributeInfo)obj).setAlias(newName);
        }
        Runnable query = new Runnable(){

            @Override
            public void run() {
                EditElementsPanel.this.disposeTextWidget();
                EditElementsPanel.this.notifyColumnDataChanged();
            }
        };
        this.columnsViewer.getTree().getShell().getDisplay().asyncExec(query);
    }

    class ColumnDataTreeProvider
    implements ITreeContentProvider,
    ILabelProvider {
        ColumnDataTreeProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ProcedureInfo) {
                if (EditElementsPanel.this.type == 0) {
                    return EditElementsPanel.this.procedureInfo.getBodyColumnInfoList();
                }
                return EditElementsPanel.this.procedureInfo.getHeaderColumnInfoList();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ColumnInfo) {
                return ((ColumnInfo)parentElement).getAttributeInfoArray();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ProcedureInfo) {
                if (EditElementsPanel.this.type == 0) {
                    return EditElementsPanel.this.procedureInfo.getBodyColumnInfoList().length > 0;
                }
                return EditElementsPanel.this.procedureInfo.getHeaderColumnInfoList().length > 0;
            }
            if (element instanceof ColumnInfo) {
                return ((ColumnInfo)element).getAttributeInfoArray().length > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Image getImage(Object element) {
            if (element instanceof ColumnInfo) {
                return EditElementsPanel.this.XSD_ELEMENT_ICON_IMG;
            }
            if (element instanceof IWsdlAttributeInfo) {
                return EditElementsPanel.this.XSD_ATTRIBUTE_ICON_IMG;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ColumnInfo) {
                return ((ColumnInfo)element).getName();
            }
            if (element instanceof IWsdlAttributeInfo) {
                return ((IWsdlAttributeInfo)element).getSignature();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

