/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.RequestInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ResponseInfo;
import org.teiid.designer.query.IProcedureService;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.wsdl.IWsdlWrapperInfo;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ProcedureGenerator
implements IWsdlWrapperInfo,
ISQLConstants,
ModelGeneratorWsdlUiConstants {
    private static final StringNameValidator nameValidator = new RelationalStringNameValidator(false);
    private RequestInfo requestInfo;
    private ResponseInfo responseInfo;
    private boolean generateWrapperProcedure;
    private String wrapperProcedureName;
    private boolean overwriteExistingProcedures;
    private Operation operation;
    private String soapAction;
    private String namespaceURI;
    private String bindingType;
    private WSDLImportWizardManager importManager;
    private boolean wrapperExists = false;
    private boolean changed;
    private boolean initializing = true;

    public ProcedureGenerator(Operation operation, WSDLImportWizardManager importManager) {
        this.operation = operation;
        this.importManager = importManager;
        this.requestInfo = new RequestInfo(operation, this);
        this.responseInfo = new ResponseInfo(operation, this);
        this.generateWrapperProcedure = true;
        this.namespaceURI = operation.getBinding().getPort().getNamespaceURI();
        this.bindingType = operation.getBinding().getPort().getBindingType();
        this.soapAction = operation.getSOAPAction();
        this.initializing = false;
    }

    WSDLImportWizardManager getImportManager() {
        return this.importManager;
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public Operation getOperation() {
        return this.operation;
    }

    void setRequestProcedureName(String name) {
        this.requestInfo.setProcedureName(name);
    }

    void setResponseProcedureName(String name) {
        this.responseInfo.setProcedureName(name);
    }

    String getRequestProcedureName() {
        return this.requestInfo.getProcedureName();
    }

    String getResponseProcedureName() {
        return this.responseInfo.getProcedureName();
    }

    public String getViewModelName() {
        String fullName = this.importManager.getViewModelName();
        if (fullName.toUpperCase().endsWith(".XMI")) {
            int endIndex = fullName.length() - 4;
            return fullName.substring(0, endIndex);
        }
        return fullName;
    }

    void setGenerateWrapperProcedure(boolean value) {
        this.generateWrapperProcedure = value;
        this.setChanged(true);
    }

    public void setWrapperProcedureName(String name) {
        this.wrapperProcedureName = name;
        this.setChanged(true);
    }

    public String getDefaultWrapperProcedureName() {
        return this.getOperation().getName();
    }

    public String getWrapperProcedureName() {
        if (this.wrapperProcedureName == null) {
            this.wrapperProcedureName = this.getDefaultWrapperProcedureName();
        }
        return this.wrapperProcedureName;
    }

    void setOverwriteExistingProcedures(boolean value) {
        if (value == this.overwriteExistingProcedures) {
            return;
        }
        this.overwriteExistingProcedures = value;
        String validRequestName = this.getRequestInfo().getDefaultProcedureName();
        String validResponseName = this.getResponseInfo().getDefaultProcedureName();
        if (!this.overwriteExistingProcedures) {
            validRequestName = ModelUtilities.getUniqueName((String)this.importManager.getViewModelLocation().getFullPath().toString(), (String)this.getViewModelName(), (String)validRequestName, (boolean)false, (boolean)false);
            validResponseName = ModelUtilities.getUniqueName((String)this.importManager.getViewModelLocation().getFullPath().toString(), (String)this.getViewModelName(), (String)validResponseName, (boolean)false, (boolean)false);
        }
        this.getRequestInfo().setProcedureName(validRequestName);
        this.getResponseInfo().setProcedureName(validResponseName);
        String validWrapperName = this.getWrapperProcedureName();
        if (!this.overwriteExistingProcedures && validWrapperName.equals(this.getDefaultWrapperProcedureName())) {
            validWrapperName = ModelUtilities.getUniqueName((String)this.importManager.getViewModelLocation().getFullPath().toString(), (String)this.getViewModelName(), (String)validWrapperName, (boolean)false, (boolean)false);
        }
        this.setWrapperProcedureName(validWrapperName);
        this.setChanged(true);
    }

    public boolean doOverwriteExistingProcedures() {
        return this.overwriteExistingProcedures;
    }

    public String getBindingType() {
        return this.bindingType;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    void setChanged(boolean value) {
        this.changed = value;
        if (this.changed && !this.initializing) {
            this.importManager.setChanged(true);
        }
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        if (this.requestInfo.isChanged()) {
            return true;
        }
        return this.responseInfo.isChanged();
    }

    public String getWrapperSqlString() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IProcedureService procedureService = queryService.getProcedureService();
        return procedureService.getSQLStatement((IWsdlWrapperInfo)this);
    }

    public String getSourceModelName() {
        return this.importManager.getSourceModelName();
    }

    IStatus getNameStatus(String name) {
        String result = nameValidator.checkValidName(name);
        if (result != null) {
            return new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", NLS.bind((String)Messages.Error_InvalidName_0_Reason_1, (Object)name, (Object)result));
        }
        return Status.OK_STATUS;
    }

    boolean wrapperExists() {
        return this.wrapperExists;
    }

    IStatus validate() {
        IStatus responseStatus;
        IStatus requestStatus;
        IStatus nameStatus;
        MultiStatus status = new MultiStatus("org.teiid.designer.modelgenerator.wsdl.ui", 0, null, null);
        this.wrapperExists = this.importManager.viewModelExists() ? ModelUtilities.eObjectExists((String)this.importManager.getViewModelLocation().getFullPath().toString(), (String)this.importManager.getViewModelName(), (String)this.wrapperProcedureName) : false;
        if (this.getWrapperProcedureName() == null) {
            status.add((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", NLS.bind((String)Messages.Error_Operation_0_WrapperProcedureNameCannotBeNullOrEmpty, (Object)this.getOperation().getName())));
        }
        if ((nameStatus = this.getNameStatus(this.getWrapperProcedureName())).getSeverity() > 1) {
            status.merge(nameStatus);
        }
        if ((requestStatus = this.getRequestInfo().validate()).getSeverity() > 1) {
            status.merge(requestStatus);
        }
        if ((responseStatus = this.getResponseInfo().validate()).getSeverity() > 1) {
            status.merge(responseStatus);
        }
        this.setChanged(false);
        return status;
    }

    public String getWrapperProcedureSqlString(Properties properties) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IProcedureService procedureService = queryService.getProcedureService();
        return procedureService.getSQLStatement((IWsdlWrapperInfo)this, properties);
    }
}

