/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity.model;

public class Parameter {
    private char COLON = (char)58;
    public static final String PREFIX = "rest_param:";
    public static final String HEADER_PREFIX = "header_param:";
    private String name;
    private String defaultValue;
    private Type type;

    public Parameter(String name, String defaultValue, Type type) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public Parameter(String keyName, String propertyValue) {
        this.name = this.extractName(keyName);
        this.defaultValue = this.extractDefaultValue(propertyValue);
        this.type = this.extractType(propertyValue);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getPropertyKey() {
        return String.valueOf(this.type.equals((Object)Type.Header) ? HEADER_PREFIX : PREFIX) + this.getName();
    }

    public String getPropertyValue() {
        return String.valueOf(this.getType().toString()) + ':' + this.getDefaultValue();
    }

    private String extractName(String keyName) {
        if (keyName.indexOf(this.COLON) > -1) {
            return keyName.substring(keyName.indexOf(this.COLON) + 1);
        }
        return keyName;
    }

    private Type extractType(String propertyValue) {
        if (propertyValue.indexOf(this.COLON) > -1) {
            return Type.fromValue(propertyValue.substring(0, propertyValue.indexOf(this.COLON)));
        }
        return Type.Query;
    }

    private String extractDefaultValue(String propertyValue) {
        if (propertyValue.indexOf(this.COLON) > -1) {
            return propertyValue.substring(propertyValue.indexOf(this.COLON) + 1);
        }
        return propertyValue;
    }

    public static enum Type {
        Query,
        URI,
        Header;


        public static Type fromValue(String value) {
            try {
                return Type.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }
}

