/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.jndi;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ReferralException;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.io.AbstractStudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.ConnectionWrapperUtils;
import org.apache.directory.studio.connection.core.io.jndi.JNDIConnectionWrapper;
import org.apache.directory.studio.connection.core.io.jndi.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.jndi.StudioSearchResult;

public class JndiStudioNamingEnumeration
extends AbstractStudioNamingEnumeration {
    private final LdapContext ctx;
    private NamingEnumeration<SearchResult> initialNamingEnumeration;
    private NamingEnumeration<SearchResult> delegate;
    private NamingException initialReferralException;

    public JndiStudioNamingEnumeration(Connection connection, LdapContext ctx, NamingEnumeration<SearchResult> delegate, NamingException initialReferralException, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Connection.ReferralHandlingMethod referralsHandlingMethod, Control[] controls, long requestNum, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        super(connection, searchBase, filter, searchControls, aliasesDereferencingMethod, referralsHandlingMethod, controls, requestNum, monitor, referralsInfo);
        this.ctx = ctx;
        this.initialNamingEnumeration = delegate;
        this.delegate = delegate;
        this.initialReferralException = initialReferralException;
        this.requestNum = requestNum;
    }

    @Override
    public void close() throws NamingException {
        this.delegate.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasMore() throws NamingException {
        logResultDoneException /* !! */  = null;
        done = false;
        try {
            if (this.initialReferralException != null) {
                referralException = this.initialReferralException;
                this.initialReferralException = null;
                throw referralException;
            }
            v0 = hasMore = this.delegate != null && this.delegate.hasMore() != false;
            if (!hasMore && !done && this.referralsInfo != null && this.referralsInfo.hasMoreReferrals()) {
                done = this.checkReferral();
            }
            done = hasMore == false;
            var5_10 = hasMore;
            return var5_10;
        }
        catch (PartialResultException pre) {
            done = true;
            logResultDoneException /* !! */  = pre;
            return (boolean)logResultDoneException /* !! */ ;
        }
        catch (ReferralException re) {
            done = true;
            logResultDoneException /* !! */  = re;
            this.referralsInfo = JNDIConnectionWrapper.handleReferralException(re, this.referralsInfo);
            if (this.referralsInfo.hasMoreReferrals()) {
                logResultDoneException /* !! */  = null;
                done = this.checkReferral();
                return done;
            }
        }
        catch (NamingException ne) {
            done = true;
            logResultDoneException /* !! */  = ne;
            throw ne;
        }
        finally {
            if (done == false) return false;
            ** for (logger : ConnectionCorePlugin.getDefault().getJndiLoggers())
        }
lbl-1000:
        // 1 sources

        {
            logger.logSearchResultDone(this.connection, this.resultEntryCounter, this.requestNum, logResultDoneException /* !! */ );
            continue;
        }
lbl37:
        // 1 sources

        return false;
    }

    @Override
    public boolean hasMoreElements() {
        throw new UnsupportedOperationException("Call hasMore() instead of hasMoreElements() !");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public StudioSearchResult next() throws NamingException {
        block6: {
            studioSearchResult = null;
            namingException = null;
            try {
                searchResult = this.delegate.next();
                ++this.resultEntryCounter;
                studioSearchResult = searchResult instanceof StudioSearchResult != false ? (StudioSearchResult)searchResult : new StudioSearchResult(searchResult, this.getConnection(), this.referralsInfo != null, null);
                var5_5 = studioSearchResult;
                return var5_5;
            }
            catch (NamingException ne) {
                namingException = ne;
                throw ne;
            }
            finally {
                if (this.delegate != this.initialNamingEnumeration) break block6;
                ** for (logger : ConnectionCorePlugin.getDefault().getJndiLoggers())
            }
lbl-1000:
            // 1 sources

            {
                logger.logSearchResultEntry(this.connection, studioSearchResult, this.requestNum, namingException);
                continue;
            }
        }
        throw var4_10;
    }

    @Override
    public StudioSearchResult nextElement() {
        throw new UnsupportedOperationException("Call next() instead of nextElement() !");
    }

    @Override
    public Connection getConnection() {
        if (this.delegate instanceof JndiStudioNamingEnumeration) {
            return ((JndiStudioNamingEnumeration)this.delegate).getConnection();
        }
        return this.connection;
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.ctx != null ? this.ctx.getResponseControls() : null;
    }

    private boolean checkReferral() {
        try {
            boolean done = false;
            if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.IGNORE) {
                done = true;
                this.delegate = null;
            } else if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY) {
                this.delegate = new NamingEnumeration<SearchResult>(){
                    List<String> urls = new ArrayList<String>();
                    {
                        while (JndiStudioNamingEnumeration.this.referralsInfo.hasMoreReferrals()) {
                            Referral referral = JndiStudioNamingEnumeration.this.referralsInfo.getNextReferral();
                            for (IJndiLogger logger : ConnectionCorePlugin.getDefault().getJndiLoggers()) {
                                logger.logSearchResultReference(JndiStudioNamingEnumeration.this.connection, referral, JndiStudioNamingEnumeration.this.referralsInfo, JndiStudioNamingEnumeration.this.requestNum, null);
                            }
                            this.urls.addAll(referral.getLdapUrls());
                        }
                    }

                    @Override
                    public SearchResult nextElement() {
                        throw new UnsupportedOperationException("Call next() instead of nextElement() !");
                    }

                    @Override
                    public boolean hasMoreElements() {
                        throw new UnsupportedOperationException("Call hasMore() instead of hasMoreElements() !");
                    }

                    @Override
                    public SearchResult next() throws NamingException {
                        try {
                            LdapUrl url = new LdapUrl(this.urls.remove(0));
                            SearchResult searchResult = new SearchResult(url.getDn().getName(), (Object)null, new BasicAttributes(), false);
                            searchResult.setNameInNamespace(url.getDn().getName());
                            StudioSearchResult ssr = new StudioSearchResult(searchResult, null, false, url);
                            return ssr;
                        }
                        catch (LdapURLEncodingException e) {
                            throw new NamingException(e.getMessage());
                        }
                    }

                    @Override
                    public boolean hasMore() throws NamingException {
                        return !this.urls.isEmpty();
                    }

                    @Override
                    public void close() throws NamingException {
                        this.urls.clear();
                        JndiStudioNamingEnumeration.this.referralsInfo = null;
                    }
                };
            } else if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW) {
                Referral referral = this.referralsInfo.getNextReferral();
                for (IJndiLogger logger : ConnectionCorePlugin.getDefault().getJndiLoggers()) {
                    logger.logSearchResultReference(this.connection, referral, this.referralsInfo, this.requestNum, null);
                }
                ArrayList urls = new ArrayList(referral.getLdapUrls());
                LdapUrl url = new LdapUrl((String)urls.get(0));
                Connection referralConnection = ConnectionWrapperUtils.getReferralConnection(referral, this.monitor, this);
                if (referralConnection != null) {
                    done = false;
                    String referralSearchBase = url.getDn() != null && !url.getDn().isEmpty() ? url.getDn().getName() : this.searchBase;
                    String referralFilter = url.getFilter() != null && url.getFilter().length() == 0 ? url.getFilter() : this.filter;
                    SearchControls referralSearchControls = new SearchControls();
                    referralSearchControls.setSearchScope(url.getScope().getScope() > -1 ? url.getScope().getScope() : this.searchControls.getSearchScope());
                    referralSearchControls.setReturningAttributes(url.getAttributes() != null && url.getAttributes().size() > 0 ? url.getAttributes().toArray(new String[url.getAttributes().size()]) : this.searchControls.getReturningAttributes());
                    referralSearchControls.setCountLimit(this.searchControls.getCountLimit());
                    referralSearchControls.setTimeLimit(this.searchControls.getTimeLimit());
                    referralSearchControls.setDerefLinkFlag(this.searchControls.getDerefLinkFlag());
                    referralSearchControls.setReturningObjFlag(this.searchControls.getReturningObjFlag());
                    this.delegate = referralConnection.getConnectionWrapper().search(referralSearchBase, referralFilter, referralSearchControls, this.aliasesDereferencingMethod, this.referralsHandlingMethod, this.controls, this.monitor, this.referralsInfo);
                } else {
                    done = true;
                    this.delegate = null;
                }
            }
            return done;
        }
        catch (LdapURLEncodingException ldapURLEncodingException) {
            return false;
        }
    }
}

