/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.eclipse.osgi.util.NLS;

public class SchemaUtils {
    public static final Set<String> OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES = new HashSet<String>();
    public static final Set<String> NON_MODIFIABLE_ATTRIBUTE_OIDS_AND_NAMES;
    private static final Comparator<String> nameAndOidComparator;
    private static final Comparator<AbstractSchemaObject> schemaElementNameComparator;

    static {
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"createTimestamp"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.1"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"creatorsName"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.3"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"modifyTimestamp"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.2"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"modifiersName"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.4"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"subschemaSubentry"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.10"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"structuralObjectClass"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.9"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"governingStructureRule"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.10"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"entryUUID"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.16.4"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"entryCSN"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"entryDN"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.20"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"objectClasses"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.6"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"attributeTypes"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.5"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"ldapSyntaxes"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.4.1.1466.101.120.16"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"matchingRules"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.4"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"matchingRuleUse"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.8"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"ditContentRules"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.2"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"ditStructureRules"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.1"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"nameForms"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.7"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"hasSubordinates"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.9"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"numSubordinates"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"subordinateCount"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"vendorName"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.4"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"vendorVersion"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.5"));
        NON_MODIFIABLE_ATTRIBUTE_OIDS_AND_NAMES = new HashSet<String>();
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"createTimestamp"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.1"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"creatorsName"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.3"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"modifyTimestamp"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.2"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"modifiersName"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.4"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"subschemaSubentry"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.10"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"structuralObjectClass"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.9"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"governingStructureRule"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.21.10"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"entryUUID"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.16.4"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"entryCSN"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"entryDN"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.20"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"hasSubordinates"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"2.5.18.9"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"numSubordinates"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"subordinateCount"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"vendorName"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.4"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"vendorVersion"));
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add(Strings.toLowerCase((String)"1.3.6.1.1.5"));
        nameAndOidComparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1.matches("[0-9\\.]+") && !s2.matches("[0-9\\.]+")) {
                    return 1;
                }
                if (!s1.matches("[0-9\\.]+") && s2.matches("[0-9\\.]+")) {
                    return -1;
                }
                return s1.compareToIgnoreCase(s2);
            }
        };
        schemaElementNameComparator = new Comparator<AbstractSchemaObject>(){

            @Override
            public int compare(AbstractSchemaObject s1, AbstractSchemaObject s2) {
                return SchemaUtils.toString(s1).compareToIgnoreCase(SchemaUtils.toString(s2));
            }
        };
    }

    public static Collection<String> getNames(Collection<? extends AbstractSchemaObject> asds) {
        TreeSet<String> nameSet = new TreeSet<String>(nameAndOidComparator);
        for (AbstractSchemaObject abstractSchemaObject : asds) {
            nameSet.addAll(abstractSchemaObject.getNames());
        }
        return nameSet;
    }

    public static String[] getNamesAsArray(Collection<? extends AbstractSchemaObject> asds) {
        return SchemaUtils.getNames(asds).toArray(new String[0]);
    }

    public static Collection<String> getNumericOids(Collection<? extends AbstractSchemaObject> descriptions) {
        HashSet<String> oids = new HashSet<String>();
        for (AbstractSchemaObject abstractSchemaObject : descriptions) {
            oids.add(abstractSchemaObject.getOid());
        }
        return oids;
    }

    public static Collection<String> getLowerCaseIdentifiers(AbstractSchemaObject asd) {
        HashSet<String> identiers = new HashSet<String>();
        if (asd.getOid() != null) {
            identiers.add(Strings.toLowerCase((String)asd.getOid()));
        }
        if (asd.getNames() != null && !asd.getNames().isEmpty()) {
            for (String name : asd.getNames()) {
                if (name == null) continue;
                identiers.add(Strings.toLowerCase((String)name));
            }
        }
        return identiers;
    }

    public static String getFriendlyIdentifier(AbstractSchemaObject asd) {
        if (asd.getNames() != null && !asd.getNames().isEmpty()) {
            return (String)asd.getNames().get(0);
        }
        return asd.getOid();
    }

    public static Collection<AttributeType> getOperationalAttributeDescriptions(Schema schema) {
        HashSet<AttributeType> operationalAtds = new HashSet<AttributeType>();
        for (AttributeType atd : schema.getAttributeTypeDescriptions()) {
            if (!SchemaUtils.isOperational(atd)) continue;
            operationalAtds.add(atd);
        }
        return operationalAtds;
    }

    public static Collection<AttributeType> getUserAttributeDescriptions(Schema schema) {
        HashSet<AttributeType> userAtds = new HashSet<AttributeType>();
        for (AttributeType atd : schema.getAttributeTypeDescriptions()) {
            if (SchemaUtils.isOperational(atd)) continue;
            userAtds.add(atd);
        }
        return userAtds;
    }

    public static boolean isOperational(AttributeType atd) {
        return !UsageEnum.USER_APPLICATIONS.equals((Object)atd.getUsage()) || Schema.DUMMY_EXTENSIONS.equals(atd.getExtensions()) || CollectionUtils.containsAny(OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES, SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)atd));
    }

    public static boolean isModifiable(AttributeType atd) {
        if (atd == null) {
            return false;
        }
        if (!atd.isUserModifiable()) {
            return false;
        }
        return !CollectionUtils.containsAny(NON_MODIFIABLE_ATTRIBUTE_OIDS_AND_NAMES, SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)atd));
    }

    public static Collection<AttributeType> getMustAttributeTypeDescriptions(IEntry entry) {
        Schema schema = entry.getBrowserConnection().getSchema();
        HashSet<AttributeType> atds = new HashSet<AttributeType>();
        Collection<ObjectClass> ocds = entry.getObjectClassDescriptions();
        if (ocds != null) {
            for (ObjectClass ocd : entry.getObjectClassDescriptions()) {
                Collection<String> musts = SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive(ocd, schema);
                for (String must : musts) {
                    AttributeType atd = schema.getAttributeTypeDescription(must);
                    atds.add(atd);
                }
            }
        }
        return atds;
    }

    public static Collection<AttributeType> getMayAttributeTypeDescriptions(IEntry entry) {
        Schema schema = entry.getBrowserConnection().getSchema();
        HashSet<AttributeType> atds = new HashSet<AttributeType>();
        Collection<ObjectClass> ocds = entry.getObjectClassDescriptions();
        if (ocds != null) {
            for (ObjectClass ocd : entry.getObjectClassDescriptions()) {
                Collection<String> mays = SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive(ocd, schema);
                for (String may : mays) {
                    AttributeType atd = schema.getAttributeTypeDescription(may);
                    atds.add(atd);
                }
            }
        }
        return atds;
    }

    public static Collection<AttributeType> getAllAttributeTypeDescriptions(IEntry entry) {
        HashSet<AttributeType> atds = new HashSet<AttributeType>();
        atds.addAll(SchemaUtils.getMustAttributeTypeDescriptions(entry));
        atds.addAll(SchemaUtils.getMayAttributeTypeDescriptions(entry));
        return atds;
    }

    public static boolean isString(LdapSyntax lsd) {
        return !SchemaUtils.isBinary(lsd);
    }

    public static boolean isBinary(LdapSyntax lsd) {
        Set<String> binarySyntaxOids = BrowserCorePlugin.getDefault().getCorePreferences().getUpperCasedBinarySyntaxOids();
        return binarySyntaxOids.contains(lsd.getOid().toUpperCase());
    }

    public static boolean isString(AttributeType atd, Schema schema) {
        return !SchemaUtils.isBinary(atd, schema);
    }

    public static boolean isBinary(AttributeType atd, Schema schema) {
        Set<String> binaryAttributeOidsAndNames = BrowserCorePlugin.getDefault().getCorePreferences().getUpperCasedBinaryAttributeOidsAndNames();
        if (binaryAttributeOidsAndNames.contains(atd.getOid().toUpperCase())) {
            return true;
        }
        for (String name : atd.getNames()) {
            if (!binaryAttributeOidsAndNames.contains(name.toUpperCase())) continue;
            return true;
        }
        String syntax = SchemaUtils.getSyntaxNumericOidTransitive(atd, schema);
        if (syntax != null && schema.hasLdapSyntaxDescription(syntax)) {
            LdapSyntax lsd = schema.getLdapSyntaxDescription(syntax);
            return SchemaUtils.isBinary(lsd);
        }
        return false;
    }

    public static Collection<AttributeType> getUsedFromAttributeTypeDescriptions(LdapSyntax lsd, Schema schema) {
        TreeSet<AbstractSchemaObject> usedFroms = new TreeSet<AbstractSchemaObject>(schemaElementNameComparator);
        for (AttributeType atd : schema.getAttributeTypeDescriptions()) {
            String syntax = SchemaUtils.getSyntaxNumericOidTransitive(atd, schema);
            if (syntax == null || lsd.getOid() == null || !Strings.toLowerCase((String)syntax).equals(Strings.toLowerCase((String)lsd.getOid()))) continue;
            usedFroms.add((AbstractSchemaObject)atd);
        }
        return usedFroms;
    }

    public static Collection<AttributeType> getUsedFromAttributeTypeDescriptions(MatchingRule mrd, Schema schema) {
        TreeSet<AbstractSchemaObject> usedFromSet = new TreeSet<AbstractSchemaObject>(schemaElementNameComparator);
        for (AttributeType atd : schema.getAttributeTypeDescriptions()) {
            Collection<String> lowerCaseIdentifiers = SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)mrd);
            String emr = SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive(atd, schema);
            String smr = SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive(atd, schema);
            String omr = SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive(atd, schema);
            if (emr != null && lowerCaseIdentifiers.contains(Strings.toLowerCase((String)emr))) {
                usedFromSet.add((AbstractSchemaObject)atd);
            }
            if (smr != null && lowerCaseIdentifiers.contains(Strings.toLowerCase((String)smr))) {
                usedFromSet.add((AbstractSchemaObject)atd);
            }
            if (omr == null || !lowerCaseIdentifiers.contains(Strings.toLowerCase((String)omr))) continue;
            usedFromSet.add((AbstractSchemaObject)atd);
        }
        return usedFromSet;
    }

    public static String getEqualityMatchingRuleNameOrNumericOidTransitive(AttributeType atd, Schema schema) {
        if (atd.getEqualityOid() != null) {
            return atd.getEqualityOid();
        }
        if (atd.getSuperiorOid() != null && schema.hasAttributeTypeDescription(atd.getSuperiorOid())) {
            AttributeType superior = schema.getAttributeTypeDescription(atd.getSuperiorOid());
            return SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static String getSubstringMatchingRuleNameOrNumericOidTransitive(AttributeType atd, Schema schema) {
        if (atd.getSubstringOid() != null) {
            return atd.getSubstringOid();
        }
        if (atd.getSuperiorOid() != null && schema.hasAttributeTypeDescription(atd.getSubstringOid())) {
            AttributeType superior = schema.getAttributeTypeDescription(atd.getSubstringOid());
            return SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static String getOrderingMatchingRuleNameOrNumericOidTransitive(AttributeType atd, Schema schema) {
        if (atd.getOrderingOid() != null) {
            return atd.getOrderingOid();
        }
        if (atd.getSuperiorOid() != null && schema.hasAttributeTypeDescription(atd.getSuperiorOid())) {
            AttributeType superior = schema.getAttributeTypeDescription(atd.getSuperiorOid());
            return SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static String getSyntaxNumericOidTransitive(AttributeType atd, Schema schema) {
        if (atd.getSyntaxOid() != null) {
            return atd.getSyntaxOid();
        }
        if (atd.getSuperiorOid() != null && schema.hasAttributeTypeDescription(atd.getSuperiorOid())) {
            AttributeType superior = schema.getAttributeTypeDescription(atd.getSuperiorOid());
            return SchemaUtils.getSyntaxNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static long getSyntaxLengthTransitive(AttributeType atd, Schema schema) {
        if (atd.getSyntaxLength() != 0L) {
            return atd.getSyntaxLength();
        }
        if (atd.getSuperiorOid() != null && schema.hasAttributeTypeDescription(atd.getSuperiorOid())) {
            AttributeType superior = schema.getAttributeTypeDescription(atd.getSuperiorOid());
            return SchemaUtils.getSyntaxLengthTransitive(superior, schema);
        }
        return -1L;
    }

    public static Collection<String> getOtherMatchingRuleDescriptionNames(AttributeType atd, Schema schema) {
        TreeSet<String> otherMatchingRules = new TreeSet<String>(nameAndOidComparator);
        for (MatchingRuleUse mrud : schema.getMatchingRuleUseDescriptions()) {
            Collection<String> atdSet = SchemaUtils.toLowerCaseSet(mrud.getApplicableAttributeOids());
            if (!atdSet.removeAll(SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)atd))) continue;
            otherMatchingRules.addAll(mrud.getNames());
        }
        return otherMatchingRules;
    }

    public static Collection<AttributeType> getDerivedAttributeTypeDescriptions(AttributeType atd, Schema schema) {
        TreeSet<AbstractSchemaObject> derivedAtds = new TreeSet<AbstractSchemaObject>(schemaElementNameComparator);
        for (AttributeType derivedAtd : schema.getAttributeTypeDescriptions()) {
            String superType = derivedAtd.getSuperiorOid();
            if (superType == null || !SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)atd).contains(Strings.toLowerCase((String)superType))) continue;
            derivedAtds.add((AbstractSchemaObject)derivedAtd);
        }
        return derivedAtds;
    }

    public static Collection<ObjectClass> getUsedAsMust(AttributeType atd, Schema schema) {
        Collection<String> lowerCaseIdentifiers = SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)atd);
        TreeSet<AbstractSchemaObject> ocds = new TreeSet<AbstractSchemaObject>(schemaElementNameComparator);
        for (ObjectClass ocd : schema.getObjectClassDescriptions()) {
            Collection<String> mustSet = SchemaUtils.toLowerCaseSet(SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive(ocd, schema));
            if (!mustSet.removeAll(lowerCaseIdentifiers)) continue;
            ocds.add((AbstractSchemaObject)ocd);
        }
        return ocds;
    }

    public static Collection<ObjectClass> getUsedAsMay(AttributeType atd, Schema schema) {
        Collection<String> lowerCaseIdentifiers = SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)atd);
        TreeSet<AbstractSchemaObject> ocds = new TreeSet<AbstractSchemaObject>(schemaElementNameComparator);
        for (ObjectClass ocd : schema.getObjectClassDescriptions()) {
            Collection<String> mustSet = SchemaUtils.toLowerCaseSet(SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive(ocd, schema));
            if (!mustSet.removeAll(lowerCaseIdentifiers)) continue;
            ocds.add((AbstractSchemaObject)ocd);
        }
        return ocds;
    }

    private static Collection<ObjectClass> getExistingSuperiorObjectClassDescription(ObjectClass ocd, Schema schema) {
        ArrayList<ObjectClass> superiorList = new ArrayList<ObjectClass>();
        for (String superior : ocd.getSuperiorOids()) {
            if (!schema.hasObjectClassDescription(superior)) continue;
            superiorList.add(schema.getObjectClassDescription(superior));
        }
        return superiorList;
    }

    public static List<ObjectClass> getSuperiorObjectClassDescriptions(ObjectClass ocd, Schema schema) {
        ArrayList<ObjectClass> superiorList = new ArrayList<ObjectClass>();
        for (String superior : ocd.getSuperiorOids()) {
            superiorList.add(schema.getObjectClassDescription(superior));
        }
        return superiorList;
    }

    public static List<ObjectClass> getSubObjectClassDescriptions(ObjectClass ocd, Schema schema) {
        ArrayList<ObjectClass> subOcds = new ArrayList<ObjectClass>();
        for (ObjectClass testOcd : schema.getObjectClassDescriptions()) {
            Collection<String> superiorNames = SchemaUtils.toLowerCaseSet(testOcd.getSuperiorOids());
            if (!superiorNames.removeAll(SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)ocd))) continue;
            subOcds.add(testOcd);
        }
        return subOcds;
    }

    public static Collection<String> getMustAttributeTypeDescriptionNamesTransitive(ObjectClass ocd, Schema schema) {
        TreeSet<String> musts = new TreeSet<String>(nameAndOidComparator);
        musts.addAll(ocd.getMustAttributeTypeOids());
        Collection<ObjectClass> superiors = SchemaUtils.getExistingSuperiorObjectClassDescription(ocd, schema);
        for (ObjectClass superior : superiors) {
            musts.addAll(SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive(superior, schema));
        }
        return musts;
    }

    public static Collection<String> getMayAttributeTypeDescriptionNamesTransitive(ObjectClass ocd, Schema schema) {
        TreeSet<String> mays = new TreeSet<String>(nameAndOidComparator);
        mays.addAll(ocd.getMayAttributeTypeOids());
        Collection<ObjectClass> superiors = SchemaUtils.getExistingSuperiorObjectClassDescription(ocd, schema);
        for (ObjectClass superior : superiors) {
            mays.addAll(SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive(superior, schema));
        }
        return mays;
    }

    public static String getLdifLine(AbstractSchemaObject asd) {
        List ldifLines = (List)asd.getExtensions().get("RAW_SCHEMA_DEFINITION_LDIF_VALUE");
        String ldifLine = ldifLines != null && !ldifLines.isEmpty() ? (String)ldifLines.get(0) : null;
        return ldifLine;
    }

    private static Collection<String> toLowerCaseSet(Collection<String> names) {
        HashSet<String> set = new HashSet<String>();
        if (names != null) {
            for (String name : names) {
                set.add(Strings.toLowerCase((String)name));
            }
        }
        return set;
    }

    public static String toString(AbstractSchemaObject asd) {
        StringBuffer sb = new StringBuffer();
        if (asd instanceof LdapSyntax) {
            if (asd.getDescription() != null && asd.getDescription().length() > 0) {
                sb.append(asd.getDescription());
            } else {
                sb.append(asd.getOid());
            }
        } else {
            boolean first = true;
            for (String name : asd.getNames()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(name);
                first = false;
            }
        }
        return sb.toString();
    }

    public static Collection<String> getEntryIncompleteMessages(IEntry entry) {
        ArrayList<String> messages = new ArrayList<String>();
        if (entry != null) {
            IAttribute attribute;
            IAttribute ocAttribute = entry.getAttribute("objectClass");
            if (ocAttribute == null) {
                messages.add(Messages.getString("SchemaUtils.NoObjectClass"));
            }
            String[] ocValues = ocAttribute.getStringValues();
            boolean structuralObjectClassAvailable = false;
            String[] stringArray = ocValues;
            int n = ocValues.length;
            int n2 = 0;
            while (n2 < n) {
                String ocValue = stringArray[n2];
                ObjectClass ocd = entry.getBrowserConnection().getSchema().getObjectClassDescription(ocValue);
                if (ocd.getType() == ObjectClassTypeEnum.STRUCTURAL) {
                    structuralObjectClassAvailable = true;
                    break;
                }
                ++n2;
            }
            if (!structuralObjectClassAvailable) {
                messages.add(Messages.getString("SchemaUtils.NoStructuralObjectClass"));
            }
            Collection<AttributeType> mustAtds = SchemaUtils.getMustAttributeTypeDescriptions(entry);
            for (AttributeType mustAtd : mustAtds) {
                AttributeHierarchy ah = entry.getAttributeWithSubtypes(mustAtd.getOid());
                if (ah != null) continue;
                messages.add(NLS.bind((String)Messages.getString("SchemaUtils.MandatoryAttributeIsMissing"), SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaObject)mustAtd)));
            }
            Collection<AttributeType> allAtds = SchemaUtils.getAllAttributeTypeDescriptions(entry);
            IAttribute[] iAttributeArray = entry.getAttributes();
            int n3 = iAttributeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AttributeType atd;
                attribute = iAttributeArray[n4];
                if (!attribute.isOperationalAttribute() && !allAtds.contains(atd = attribute.getAttributeTypeDescription())) {
                    messages.add(NLS.bind((String)Messages.getString("SchemaUtils.AttributeNotAllowed"), (Object)attribute.getDescription()));
                }
                ++n4;
            }
            iAttributeArray = entry.getAttributes();
            n3 = iAttributeArray.length;
            n4 = 0;
            while (n4 < n3) {
                attribute = iAttributeArray[n4];
                IValue[] iValueArray = attribute.getValues();
                int n5 = iValueArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IValue value = iValueArray[n6];
                    if (value.isEmpty()) {
                        messages.add(NLS.bind((String)Messages.getString("SchemaUtils.EmptyValue"), (Object)attribute.getDescription()));
                    }
                    ++n6;
                }
                ++n4;
            }
        }
        return messages;
    }
}

