/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ManageReferralControl;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.EntryRenamedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.jobs.CopyEntriesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.DeleteEntriesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SimulateRenameDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.core.runtime.IProgressMonitor;

public class RenameEntryRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;
    private IEntry oldEntry;
    private Rdn newRdn;
    private IEntry newEntry;
    private Set<ISearch> searchesToUpdateSet = new HashSet<ISearch>();
    private SimulateRenameDialog dialog;

    public RenameEntryRunnable(IEntry entry, Rdn newRdn, SimulateRenameDialog dialog) {
        this.browserConnection = entry.getBrowserConnection();
        this.oldEntry = entry;
        this.newEntry = null;
        this.newRdn = newRdn;
        this.dialog = dialog;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__rename_entry_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.add(this.oldEntry.getParententry());
        return l.toArray();
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__rename_entry_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__rename_entry_task, (Object[])new String[]{this.oldEntry.getDn().getName()}), 3);
        monitor.reportProgress(" ");
        monitor.worked(1);
        Dn oldDn = this.oldEntry.getDn();
        Dn parentDn = oldDn.getParent();
        Dn newDn = null;
        try {
            newDn = parentDn.add(this.newRdn);
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            newDn = Dn.EMPTY_DN;
        }
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        RenameEntryRunnable.renameEntry(this.browserConnection, this.oldEntry, newDn, dummyMonitor);
        if (dummyMonitor.errorsReported() && !monitor.isCanceled()) {
            if (this.dialog != null && dummyMonitor.getException() instanceof ContextNotEmptyException) {
                this.dialog.setEntryInfo(this.browserConnection, oldDn, newDn);
                this.dialog.open();
                boolean isSimulatedRename = this.dialog.isSimulateRename();
                if (isSimulatedRename) {
                    dummyMonitor.reset();
                    CopyEntriesRunnable.copyEntry(this.oldEntry, this.oldEntry.getParententry(), this.newRdn, 2, 0, null, dummyMonitor, monitor);
                    if (!dummyMonitor.errorsReported()) {
                        dummyMonitor.reset();
                        DeleteEntriesRunnable.optimisticDeleteEntryRecursive(this.browserConnection, oldDn, this.oldEntry.isReferral(), false, 0, dummyMonitor, monitor);
                    }
                } else {
                    Exception exception = dummyMonitor.getException();
                    monitor.reportError(exception);
                }
            } else {
                Exception exception = dummyMonitor.getException();
                monitor.reportError(exception);
            }
        }
        if (!monitor.errorsReported() && !monitor.isCanceled()) {
            this.browserConnection.uncacheEntryRecursive(this.oldEntry);
            IEntry parent = this.oldEntry.getParententry();
            if (parent != null) {
                boolean hasMoreChildren = parent.hasMoreChildren();
                parent.deleteChild(this.oldEntry);
                ArrayList<StudioControl> controls = new ArrayList<StudioControl>();
                if (this.oldEntry.isReferral()) {
                    controls.add(StudioControl.MANAGEDSAIT_CONTROL);
                }
                dummyMonitor.reset();
                this.newEntry = ReadEntryRunnable.getEntry(this.browserConnection, newDn, controls, dummyMonitor);
                dummyMonitor.done();
                if (this.newEntry != null) {
                    parent.addChild(this.newEntry);
                }
                parent.setHasMoreChildren(hasMoreChildren);
                List<ISearch> searches = this.browserConnection.getSearchManager().getSearches();
                block2: for (ISearch search : searches) {
                    ISearchResult[] searchResults;
                    if (search.getSearchResults() == null) continue;
                    ISearchResult[] iSearchResultArray = searchResults = search.getSearchResults();
                    int n = searchResults.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISearchResult result = iSearchResultArray[n2];
                        if (this.oldEntry.equals(result.getEntry())) {
                            search.setSearchResults(null);
                            this.searchesToUpdateSet.add(search);
                            continue block2;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        if (this.oldEntry != null && this.newEntry != null) {
            EventRegistry.fireEntryUpdated(new EntryRenamedEvent(this.oldEntry, this.newEntry), this);
            for (ISearch search : this.searchesToUpdateSet) {
                EventRegistry.fireSearchUpdated(new SearchUpdateEvent(search, SearchUpdateEvent.EventDetail.SEARCH_PERFORMED), this);
            }
        }
    }

    static void renameEntry(IBrowserConnection browserConnection, IEntry entry, Dn newDn, StudioProgressMonitor monitor) {
        String oldDnString = entry.getDn().getName();
        String newDnString = newDn.getName();
        Control[] controls = null;
        if (entry.isReferral()) {
            controls = new Control[]{new ManageReferralControl(false)};
        }
        if (browserConnection.getConnection() != null) {
            browserConnection.getConnection().getConnectionWrapper().renameEntry(oldDnString, newDnString, true, controls, monitor, null);
        }
    }
}

