/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.core.io.ConnectionIOException;
import org.apache.directory.studio.ldapbrowser.core.BrowserConnectionIO;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.model.BookmarkParameter;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Bookmark;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;

public class BrowserConnectionManager
implements ConnectionUpdateListener,
BrowserConnectionUpdateListener,
SearchUpdateListener,
BookmarkUpdateListener {
    private Map<String, IBrowserConnection> connectionMap = new HashMap<String, IBrowserConnection>();

    public BrowserConnectionManager() {
        EventRegistry.suspendEventFiringInCurrentThread();
        this.loadBrowserConnections();
        EventRegistry.resumeEventFiringInCurrentThread();
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionCorePlugin.getDefault().getEventRunner());
        EventRegistry.addSearchUpdateListener(this, BrowserCorePlugin.getDefault().getEventRunner());
        EventRegistry.addBookmarkUpdateListener(this, BrowserCorePlugin.getDefault().getEventRunner());
        EventRegistry.addBrowserConnectionUpdateListener(this, BrowserCorePlugin.getDefault().getEventRunner());
    }

    public static final String getSchemaCacheFileName(String id) {
        return BrowserCorePlugin.getDefault().getStateLocation().append("schema-" + Utils.getFilenameString((String)id) + ".ldif").toOSString();
    }

    public static final String getBrowserConnectionStoreFileName() {
        String filename = BrowserCorePlugin.getDefault().getStateLocation().append("browserconnections.xml").toOSString();
        File file = new File(filename);
        if (!file.exists()) {
            String[] oldFilenames;
            oldFilenames = new String[]{filename.replace("org.apache.directory.studio.ldapbrowser.core", "org.apache.directory.ldapstudio.browser.core"), oldFilenames[0].replace(".ApacheDirectoryStudio", ".ldapstudio")};
            int i = 0;
            while (i < oldFilenames.length) {
                File oldFile = new File(oldFilenames[i]);
                if (oldFile.exists()) {
                    try {
                        String oldContent = FileUtils.readFileToString((File)oldFile, (String)"UTF-8");
                        String newContent = oldContent.replace("org.apache.directory.ldapstudio.browser.core", "org.apache.directory.studio.ldapbrowser.core");
                        FileUtils.writeStringToFile((File)file, (String)newContent, (String)"UTF-8");
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return filename;
    }

    public IBrowserConnection getBrowserConnectionById(String id) {
        return this.connectionMap.get(id);
    }

    public IBrowserConnection getBrowserConnectionByName(String name) {
        Connection connection = ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionByName(name);
        return this.getBrowserConnection(connection);
    }

    public IBrowserConnection getBrowserConnection(Connection connection) {
        return connection != null ? this.getBrowserConnectionById(connection.getId()) : null;
    }

    public IBrowserConnection[] getBrowserConnections() {
        return this.connectionMap.values().toArray(new IBrowserConnection[0]);
    }

    public void connectionRemoved(Connection connection) {
        this.connectionMap.remove(connection.getId());
        File schemaFile = new File(BrowserConnectionManager.getSchemaCacheFileName(connection.getId()));
        if (schemaFile.exists()) {
            schemaFile.delete();
        }
        this.saveBrowserConnections();
    }

    public void connectionAdded(Connection connection) {
        BrowserConnection browserConnection = new BrowserConnection(connection);
        this.connectionMap.put(connection.getId(), browserConnection);
        this.saveBrowserConnections();
    }

    public void connectionUpdated(Connection connection) {
        this.saveBrowserConnections();
        this.saveSchema(this.getBrowserConnection(connection));
    }

    public void connectionOpened(Connection connection) {
    }

    public void connectionClosed(Connection connection) {
    }

    public void connectionFolderModified(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
    }

    @Override
    public void browserConnectionUpdated(BrowserConnectionUpdateEvent browserConnectionUpdateEvent) {
        if (browserConnectionUpdateEvent.getDetail() == BrowserConnectionUpdateEvent.Detail.BROWSER_CONNECTION_OPENED || browserConnectionUpdateEvent.getDetail() == BrowserConnectionUpdateEvent.Detail.SCHEMA_UPDATED) {
            this.saveSchema(browserConnectionUpdateEvent.getBrowserConnection());
        }
    }

    @Override
    public void searchUpdated(SearchUpdateEvent searchUpdateEvent) {
        if (searchUpdateEvent.getDetail() == SearchUpdateEvent.EventDetail.SEARCH_ADDED || searchUpdateEvent.getDetail() == SearchUpdateEvent.EventDetail.SEARCH_REMOVED || searchUpdateEvent.getDetail() == SearchUpdateEvent.EventDetail.SEARCH_RENAMED || searchUpdateEvent.getDetail() == SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED) {
            this.saveBrowserConnections();
        }
    }

    @Override
    public void bookmarkUpdated(BookmarkUpdateEvent bookmarkUpdateEvent) {
        if (bookmarkUpdateEvent.getDetail() == BookmarkUpdateEvent.Detail.BOOKMARK_ADDED || bookmarkUpdateEvent.getDetail() == BookmarkUpdateEvent.Detail.BOOKMARK_REMOVED || bookmarkUpdateEvent.getDetail() == BookmarkUpdateEvent.Detail.BOOKMARK_UPDATED) {
            this.saveBrowserConnections();
        }
    }

    private void saveBrowserConnections() {
        try {
            BrowserConnectionIO.save(new FileOutputStream(String.valueOf(BrowserConnectionManager.getBrowserConnectionStoreFileName()) + "-temp"), this.connectionMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(BrowserConnectionManager.getBrowserConnectionStoreFileName());
        File tempFile = new File(String.valueOf(BrowserConnectionManager.getBrowserConnectionStoreFileName()) + "-temp");
        if (file.exists()) {
            file.delete();
        }
        try {
            String content = FileUtils.readFileToString((File)tempFile, (String)"UTF-8");
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveSchema(IBrowserConnection browserConnection) {
        if (browserConnection == null) {
            return;
        }
        try {
            String filename = BrowserConnectionManager.getSchemaCacheFileName(browserConnection.getConnection().getId());
            FileWriter writer = new FileWriter(filename);
            browserConnection.getSchema().saveToLdif(writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBrowserConnections() {
        block20: {
            Connection[] connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
            int i = 0;
            while (i < connections.length) {
                Connection connection = connections[i];
                BrowserConnection browserConnection = new BrowserConnection(connection);
                this.connectionMap.put(connection.getId(), browserConnection);
                try {
                    String schemaFilename = BrowserConnectionManager.getSchemaCacheFileName(connection.getId());
                    FileReader reader = new FileReader(schemaFilename);
                    Schema schema = new Schema();
                    schema.loadFromLdif(reader);
                    browserConnection.setSchema(schema);
                }
                catch (Exception exception) {}
                ++i;
            }
            try {
                String fileName = BrowserConnectionManager.getBrowserConnectionStoreFileName();
                File file = new File(fileName);
                if (!file.exists()) break block20;
                String oldContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
                if (!oldContent.contains("java.beans.XMLDecoder")) {
                    try {
                        BrowserConnectionIO.load(new FileInputStream(BrowserConnectionManager.getBrowserConnectionStoreFileName()), this.connectionMap);
                        break block20;
                    }
                    catch (Exception exception) {
                        try {
                            BrowserConnectionIO.load(new FileInputStream(String.valueOf(BrowserConnectionManager.getBrowserConnectionStoreFileName()) + "-temp"), this.connectionMap);
                            break block20;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return;
                        }
                        catch (ConnectionIOException connectionIOException) {
                            return;
                        }
                    }
                }
                Object[][] object = (Object[][])this.load(BrowserConnectionManager.getBrowserConnectionStoreFileName());
                if (object == null) break block20;
                try {
                    int i2 = 0;
                    while (i2 < object.length) {
                        String connectionId = (String)object[i2][0];
                        IBrowserConnection browserConnection = this.getBrowserConnectionById(connectionId);
                        if (browserConnection != null) {
                            int k;
                            if (object[i2].length > 0) {
                                SearchParameter[] searchParameters = (SearchParameter[])object[i2][1];
                                k = 0;
                                while (k < searchParameters.length) {
                                    Search search = new Search(browserConnection, searchParameters[k]);
                                    browserConnection.getSearchManager().addSearch(search);
                                    ++k;
                                }
                            }
                            if (object[i2].length > 1) {
                                BookmarkParameter[] bookmarkParameters = (BookmarkParameter[])object[i2][2];
                                k = 0;
                                while (k < bookmarkParameters.length) {
                                    Bookmark bookmark = new Bookmark(browserConnection, bookmarkParameters[k]);
                                    browserConnection.getBookmarkManager().addBookmark(bookmark);
                                    ++k;
                                }
                            }
                        }
                        ++i2;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {}
        }
    }

    private synchronized Object load(String filename) {
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(filename)));
            Object object = decoder.readObject();
            decoder.close();
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (Exception exception) {
            String tempFilename = String.valueOf(filename) + "-temp";
            try {
                XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(tempFilename)));
                Object object = decoder.readObject();
                decoder.close();
                return object;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    class TypeSafeEnumPersistenceDelegate
    extends PersistenceDelegate {
        TypeSafeEnumPersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Class<?> type = oldInstance.getClass();
            if (!Modifier.isPublic(type.getModifiers())) {
                throw new IllegalArgumentException("Could not instantiate instance of non-public class: " + oldInstance);
            }
            Field[] fieldArray = type.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int mod = field.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && type == field.getDeclaringClass()) {
                    try {
                        if (oldInstance == field.get(null)) {
                            return new Expression(oldInstance, field, "get", new Object[1]);
                        }
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalArgumentException("Could not get value of the field: " + field, exception);
                    }
                }
                ++n2;
            }
            throw new IllegalArgumentException("Could not instantiate value: " + oldInstance);
        }
    }
}

