/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.teiid.core.designer.plugin.PluginUtilities;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.jdbc.relational.RelationalModelProcessor;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMappingImpl;

public class JdbcModelProcessorManager {
    public static final String DELIMITER = ".";
    public static final String JDBC_DEFAULT = "JDBC (default)";
    public static final String JDBC_TYPE = "JDBC";
    private static Map<String, IExtension> processorExtensionMap;
    private static Map<String, String> processorNameMap;
    private static boolean processorsLoaded;

    static {
        processorsLoaded = false;
    }

    public static RelationalModelProcessor createRelationalModelProcessor() {
        return JdbcModelProcessorManager.createRelationalModelProcessor(RelationalTypeMappingImpl.getInstance(), JDBC_TYPE);
    }

    public static RelationalModelProcessor createRelationalModelProcessor(RelationalTypeMapping mapping, String processorType) {
        RelationalModelProcessor processor = JdbcModelProcessorManager.getProcessor(processorType);
        if (mapping != null && processor instanceof RelationalModelProcessorImpl) {
            ((RelationalModelProcessorImpl)processor).setTypeMapping(mapping);
        }
        return processor;
    }

    public static RelationalModelProcessor createRelationalModelProcessor(String processorType) {
        return JdbcModelProcessorManager.createRelationalModelProcessor(RelationalTypeMappingImpl.getInstance(), processorType);
    }

    public static Collection<String> getMetadataProcessorNames() {
        JdbcModelProcessorManager.loadProcessors();
        return processorNameMap.values();
    }

    public static Collection<String> getMetadataProcessorTypes() {
        JdbcModelProcessorManager.loadProcessors();
        return processorExtensionMap.keySet();
    }

    private static RelationalModelProcessor getProcessor(IExtension extension) {
        IConfigurationElement[] elems = extension.getConfigurationElements();
        Object result = null;
        int j = 0;
        while (j < elems.length) {
            IConfigurationElement elem = elems[j];
            String elemName = elem.getName();
            if (elemName != null && elemName.equals("processorClass")) {
                try {
                    result = elem.createExecutableExtension("name");
                }
                catch (Throwable e) {
                    ModelerJdbcRelationalConstants.Util.log(e);
                }
            }
            ++j;
        }
        if (result instanceof RelationalModelProcessor) {
            return (RelationalModelProcessor)result;
        }
        return null;
    }

    private static RelationalModelProcessor getProcessor(String key) {
        RelationalModelProcessor processor;
        JdbcModelProcessorManager.loadProcessors();
        IExtension extension = processorExtensionMap.get(key);
        if (extension != null && (processor = JdbcModelProcessorManager.getProcessor(extension)) != null) {
            return processor;
        }
        return new RelationalModelProcessorImpl();
    }

    public static String getProcessorNameWithType(String type) {
        JdbcModelProcessorManager.loadProcessors();
        for (String nextKey : processorNameMap.keySet()) {
            String nextValue = processorNameMap.get(nextKey);
            if (!nextKey.equalsIgnoreCase(type)) continue;
            return nextValue;
        }
        return JDBC_DEFAULT;
    }

    public static String getProcessorTypeWithName(String nameKey) {
        JdbcModelProcessorManager.loadProcessors();
        for (String nextKey : processorNameMap.keySet()) {
            String nextValue = processorNameMap.get(nextKey);
            if (!nextValue.equalsIgnoreCase(nameKey)) continue;
            return nextKey;
        }
        return JDBC_TYPE;
    }

    private static void loadProcessors() {
        if (!processorsLoaded) {
            processorExtensionMap = new HashMap<String, IExtension>();
            processorNameMap = new HashMap<String, String>();
            IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.jdbc.relational.modelProcessor");
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elems = extension.getConfigurationElements();
                String processorType = null;
                String processorName = extension.getLabel();
                int j = 0;
                while (j < elems.length) {
                    IConfigurationElement elem = elems[j];
                    String elemName = elem.getName();
                    if (elemName != null && elemName.equals("processorType")) {
                        processorType = elem.getAttribute("name");
                    }
                    ++j;
                }
                if (processorName != null && processorType != null) {
                    processorExtensionMap.put(processorType, extension);
                    processorNameMap.put(processorType, processorName);
                }
                ++i;
            }
            processorNameMap.put(JDBC_TYPE, JDBC_DEFAULT);
            processorsLoaded = true;
        }
    }

    public static class EXTENSION_POINT {

        public static class MODEL_PROCESSOR {
            public static final String ID = "modelProcessor";
            public static final String UNIQUE_ID = "org.teiid.designer.jdbc.relational.modelProcessor";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String PROCESSOR_CLASS = "processorClass";
                public static final String PROCESSOR_TYPE = "processorType";
            }
        }
    }
}

