/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.publish.jmx;

import java.util.Collection;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.publish.jmx.IJMXPublishBehaviour;
import org.fusesource.ide.server.karaf.core.server.subsystems.OSGiBundleState;

public class OSGIMBeanPublishBehaviour
implements IJMXPublishBehaviour {
    private static final String OSGI_FRAMEWORK_MBEAN = "osgi.core:type=framework,*";
    private static final String OSGI_BUNDLESTATE_MBEAN = "osgi.core:type=bundleState,*";
    private ObjectName objectNameBundleState;
    private ObjectName objectNameFramework;

    @Override
    public long getBundleId(MBeanServerConnection mbsc, String bundleSymbolicName, String version) {
        try {
            TabularData tabData = (TabularData)mbsc.invoke(this.objectNameBundleState, "listBundles", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String bsn = cd.get("SymbolicName").toString();
                String id = cd.get("Identifier").toString();
                String ver = cd.get("Version").toString();
                if (!(version != null ? bsn.equals(bundleSymbolicName) && ver.equals(version) : bsn.equals(bundleSymbolicName))) continue;
                return Long.parseLong(id);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long installBundle(MBeanServerConnection mbsc, String bundlePath) {
        try {
            Object retVal = mbsc.invoke(this.objectNameFramework, "installBundle", new Object[]{bundlePath}, new String[]{String.class.getName()});
            if (retVal instanceof Long) {
                long bid = (Long)retVal;
                mbsc.invoke(this.objectNameFramework, "startBundle", new Object[]{bid}, new String[]{"long"});
                return bid;
            }
            Activator.getLogger().error(retVal.toString());
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public boolean updateBundle(MBeanServerConnection mbsc, long bundleId, String bundlePath) {
        try {
            mbsc.invoke(this.objectNameFramework, "updateBundleFromURL", new Object[]{bundleId, bundlePath}, new String[]{"long", String.class.getName()});
            return true;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean uninstallBundle(MBeanServerConnection mbsc, long bundleId) {
        try {
            mbsc.invoke(this.objectNameFramework, "uninstallBundle", new Object[]{bundleId}, new String[]{"long"});
            return true;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public int getBundleStatus(MBeanServerConnection mbsc, long bundleId) {
        try {
            TabularData tabData = (TabularData)mbsc.invoke(this.objectNameBundleState, "listBundles", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String id = cd.get("Identifier").toString();
                String state = cd.get("State").toString();
                long longID = Long.parseLong(id);
                if (bundleId != longID) continue;
                return OSGiBundleState.getStatusForString(state);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return 0;
    }

    @Override
    public boolean canHandle(MBeanServerConnection mbsc) {
        ObjectInstance oi;
        ObjectInstance oMbean;
        Set<ObjectInstance> mbeans;
        block7: {
            block6: {
                try {
                    this.objectNameBundleState = new ObjectName(OSGI_BUNDLESTATE_MBEAN);
                    this.objectNameFramework = new ObjectName(OSGI_FRAMEWORK_MBEAN);
                    mbeans = mbsc.queryMBeans(this.objectNameBundleState, null);
                    if (mbeans.size() == 1) break block6;
                    return false;
                }
                catch (Exception ex) {
                    Activator.getLogger().error((Throwable)ex);
                    return false;
                }
            }
            oMbean = mbeans.iterator().next();
            if (oMbean instanceof ObjectInstance) {
                oi = oMbean;
                this.objectNameBundleState = oi.getObjectName();
            }
            if ((mbeans = mbsc.queryMBeans(this.objectNameFramework, null)).size() == 1) break block7;
            return false;
        }
        oMbean = mbeans.iterator().next();
        if (oMbean instanceof ObjectInstance) {
            oi = oMbean;
            this.objectNameFramework = oi.getObjectName();
        }
        return true;
    }
}

