/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.io;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Element;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.model.RouteDefinition;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.io.ContainerMarshallerSupport;
import org.fusesource.ide.commons.camel.tools.RouteXml;
import org.fusesource.ide.commons.camel.tools.XmlModel;
import org.fusesource.ide.commons.util.IOUtils;
import org.fusesource.ide.commons.util.Strings;

public class XmlContainerMarshaller
extends ContainerMarshallerSupport {
    private boolean noRoutesOnLoad;

    @Override
    public RouteContainer loadRoutes(File file) {
        try {
            RouteXml helper = this.createXmlHelper();
            Activator.getLogger().debug("Loading file: " + file);
            XmlModel model = helper.unmarshal(file);
            if (model.getRouteDefinitionList().size() < 1) {
                this.noRoutesOnLoad = true;
            }
            return this.toContainer(model);
        }
        catch (Exception e) {
            Activator.getLogger().error("Failed to load Camel mode: " + e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public RouteContainer loadRoutesFromText(String text) {
        try {
            RouteXml helper = this.createXmlHelper();
            XmlModel model = helper.unmarshal(text);
            if (model.getRouteDefinitionList().size() < 1) {
                this.noRoutesOnLoad = true;
            }
            return this.toContainer(model);
        }
        catch (Exception e) {
            Activator.getLogger().error("Failed to load Camel mode: " + e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected RouteContainer toContainer(XmlModel model) {
        List routes = model.getRouteDefinitionList();
        RouteContainer answer = new RouteContainer();
        String id = null;
        if (model.getContextElement() != null && model.getContextElement().getId() != null) {
            id = model.getContextElement().getId();
        } else {
            if (model.getNode() == null) {
                Exception e = new Exception("Unable to determine route container, no node detected.");
                Activator.getLogger().warning((Throwable)e);
                throw new RuntimeException(e);
            }
            Element e = (Element)model.getNode();
            Attribute a = e.getAttribute("id");
            if (a != null) {
                id = a.getValue();
            }
        }
        answer.setId(id);
        answer.addRoutes(routes);
        answer.setBeans(model.beanMap());
        answer.setCamelContextEndpointUris(model.endpointUriSet());
        answer.setModel(model);
        return answer;
    }

    @Override
    public void save(IFile ifile, RouteContainer model, IProgressMonitor monitor) throws CoreException {
        RouteXml helper = this.createXmlHelper();
        List<RouteDefinition> list = model.createRouteDefinitions();
        try {
            String text = IOUtils.loadText((InputStream)ifile.getContents(), (String)ifile.getCharset());
            String newText = helper.marshalToText(text, list, model.getModel().getContextElement());
            ifile.setContents((InputStream)new ByteArrayInputStream(newText.getBytes()), true, true, monitor);
        }
        catch (Exception ex) {
            Activator.getLogger().error("Unable to load text from stream", (Throwable)ex);
        }
    }

    @Override
    public void save(File file, RouteContainer model) {
        List<RouteDefinition> list = model.createRouteDefinitions();
        RouteXml helper = this.createXmlHelper();
        if (list.size() == 1 && list.get(0).getInputs().size() < 1 && list.get(0).getOutputs().size() < 1 && this.isNoRoutesOnLoad()) {
            list.clear();
        }
        Activator.getLogger().debug("Saving to file " + file + " routes: " + list);
        try {
            helper.marshal(file, list);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    protected RouteXml createXmlHelper() {
        return new RouteXml();
    }

    @Override
    public String updateText(String xmlText, RouteContainer model) {
        List<RouteDefinition> list = model.createRouteDefinitions();
        RouteXml helper = this.createXmlHelper();
        String newXMLText = xmlText;
        if (list.size() == 1 && list.get(0).getInputs().size() < 1 && list.get(0).getOutputs().size() < 1 && this.isNoRoutesOnLoad()) {
            list.clear();
        }
        if (!Strings.isBlank((String)model.getContextId())) {
            int endPos;
            int pos = xmlText.indexOf("<camelContext ");
            if (pos == -1) {
                pos = xmlText.indexOf(":camelContext ");
            }
            if (pos != -1 && (endPos = xmlText.indexOf(">", pos + 1)) != -1 && (xmlText.indexOf(" id=", pos) == -1 || xmlText.indexOf(" id=", pos) >= endPos)) {
                newXMLText = xmlText.substring(0, pos + ":camelContext ".length());
                newXMLText = String.valueOf(newXMLText) + "id=\"" + model.getCamelContextId() + "\" ";
                newXMLText = String.valueOf(newXMLText) + xmlText.substring(pos + ":camelContext ".length());
            }
        }
        try {
            return helper.marshalToText(newXMLText, list, model.getModel().getContextElement());
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean isNoRoutesOnLoad() {
        return this.noRoutesOnLoad;
    }
}

