/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.config.BatchResequencerConfig;
import org.apache.camel.model.config.ResequencerConfig;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.ExpressionPropertyDescriptor;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.ComplexUnionPropertyDescriptor;
import org.fusesource.ide.commons.properties.UnionTypeValue;

public class Resequence
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "Resequence.Expression";
    public static final String PROPERTY_RESEQUENCERCONFIG = "Resequence.ResequencerConfig";
    private ExpressionDefinition expression;
    private ResequencerConfig resequencerConfig;

    public Resequence() {
    }

    public Resequence(ResequenceDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "resequence.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "resequenceEIP";
    }

    @Override
    public String getCategoryName() {
        return "Routing";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        if (!this.isSame(oldValue, expression)) {
            this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
        }
    }

    public ResequencerConfig getResequencerConfig() {
        return this.resequencerConfig;
    }

    public void setResequencerConfig(ResequencerConfig resequencerConfig) {
        ResequencerConfig oldValue = this.resequencerConfig;
        this.resequencerConfig = resequencerConfig;
        if (!this.isSame(oldValue, resequencerConfig)) {
            this.firePropertyChange(PROPERTY_RESEQUENCERCONFIG, oldValue, resequencerConfig);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelResequenceExpression);
        ComplexUnionPropertyDescriptor descResequencerConfig = new ComplexUnionPropertyDescriptor((Object)PROPERTY_RESEQUENCERCONFIG, Messages.propertyLabelResequenceResequencerConfig, ResequencerConfig.class, new UnionTypeValue[]{new UnionTypeValue("batch-config", BatchResequencerConfig.class), new UnionTypeValue("stream-config", StreamResequencerConfig.class)});
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_RESEQUENCERCONFIG, (PropertyDescriptor)descResequencerConfig);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
            return;
        }
        if (PROPERTY_RESEQUENCERCONFIG.equals(id)) {
            this.setResequencerConfig(Objects.convertTo(value, ResequencerConfig.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_RESEQUENCERCONFIG.equals(id)) {
            return this.getResequencerConfig();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        ResequenceDefinition answer = new ResequenceDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setResequencerConfig(this.toXmlPropertyValue(PROPERTY_RESEQUENCERCONFIG, this.getResequencerConfig()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return ResequenceDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof ResequenceDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ResequenceDefinition. Was " + processor.getClass().getName());
        }
        ResequenceDefinition node = (ResequenceDefinition)processor;
        this.setExpression(node.getExpression());
        this.setResequencerConfig(node.getResequencerConfig());
    }
}

