/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.CircuitBreakerLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;
import org.fusesource.ide.commons.properties.ComplexUnionPropertyDescriptor;
import org.fusesource.ide.commons.properties.UnionTypeValue;

public class LoadBalance
extends AbstractNode {
    public static final String PROPERTY_INHERITERRORHANDLER = "LoadBalance.InheritErrorHandler";
    public static final String PROPERTY_REF = "LoadBalance.Ref";
    public static final String PROPERTY_LOADBALANCERTYPE = "LoadBalance.LoadBalancerType";
    private Boolean inheritErrorHandler;
    private String ref;
    private LoadBalancerDefinition loadBalancerType;

    public LoadBalance() {
    }

    public LoadBalance(LoadBalanceDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "loadBalance.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "loadBalanceEIP";
    }

    @Override
    public String getCategoryName() {
        return "Routing";
    }

    @Override
    public Boolean getInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    @Override
    public void setInheritErrorHandler(Boolean inheritErrorHandler) {
        Boolean oldValue = this.inheritErrorHandler;
        this.inheritErrorHandler = inheritErrorHandler;
        if (!this.isSame(oldValue, inheritErrorHandler)) {
            this.firePropertyChange(PROPERTY_INHERITERRORHANDLER, oldValue, inheritErrorHandler);
        }
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        String oldValue = this.ref;
        this.ref = ref;
        if (!this.isSame(oldValue, ref)) {
            this.firePropertyChange(PROPERTY_REF, oldValue, ref);
        }
    }

    public LoadBalancerDefinition getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public void setLoadBalancerType(LoadBalancerDefinition loadBalancerType) {
        LoadBalancerDefinition oldValue = this.loadBalancerType;
        this.loadBalancerType = loadBalancerType;
        if (!this.isSame(oldValue, loadBalancerType)) {
            this.firePropertyChange(PROPERTY_LOADBALANCERTYPE, oldValue, loadBalancerType);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        BooleanPropertyDescriptor descInheritErrorHandler = new BooleanPropertyDescriptor((Object)PROPERTY_INHERITERRORHANDLER, Messages.propertyLabelLoadBalanceInheritErrorHandler);
        TextPropertyDescriptor descRef = new TextPropertyDescriptor((Object)PROPERTY_REF, Messages.propertyLabelLoadBalanceRef);
        ComplexUnionPropertyDescriptor descLoadBalancerType = new ComplexUnionPropertyDescriptor((Object)PROPERTY_LOADBALANCERTYPE, Messages.propertyLabelLoadBalanceLoadBalancerType, LoadBalancerDefinition.class, new UnionTypeValue[]{new UnionTypeValue("failover", FailoverLoadBalancerDefinition.class), new UnionTypeValue("random", RandomLoadBalancerDefinition.class), new UnionTypeValue("custom", CustomLoadBalancerDefinition.class), new UnionTypeValue("roundRobin", RoundRobinLoadBalancerDefinition.class), new UnionTypeValue("sticky", StickyLoadBalancerDefinition.class), new UnionTypeValue("topic", TopicLoadBalancerDefinition.class), new UnionTypeValue("weighted", WeightedLoadBalancerDefinition.class), new UnionTypeValue("circuitBreaker", CircuitBreakerLoadBalancerDefinition.class)});
        descriptors.put(PROPERTY_INHERITERRORHANDLER, (PropertyDescriptor)descInheritErrorHandler);
        descriptors.put(PROPERTY_REF, (PropertyDescriptor)descRef);
        descriptors.put(PROPERTY_LOADBALANCERTYPE, (PropertyDescriptor)descLoadBalancerType);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_INHERITERRORHANDLER.equals(id)) {
            this.setInheritErrorHandler(Objects.convertTo(value, Boolean.class));
            return;
        }
        if (PROPERTY_REF.equals(id)) {
            this.setRef(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_LOADBALANCERTYPE.equals(id)) {
            this.setLoadBalancerType(Objects.convertTo(value, LoadBalancerDefinition.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_INHERITERRORHANDLER.equals(id)) {
            return Objects.getField(this, "inheritErrorHandler");
        }
        if (PROPERTY_REF.equals(id)) {
            return this.getRef();
        }
        if (PROPERTY_LOADBALANCERTYPE.equals(id)) {
            return this.getLoadBalancerType();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        answer.setInheritErrorHandler(this.toXmlPropertyValue(PROPERTY_INHERITERRORHANDLER, (Boolean)Objects.getField(this, "inheritErrorHandler")));
        answer.setRef(this.toXmlPropertyValue(PROPERTY_REF, this.getRef()));
        answer.setLoadBalancerType(this.toXmlPropertyValue(PROPERTY_LOADBALANCERTYPE, this.getLoadBalancerType()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return LoadBalanceDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof LoadBalanceDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof LoadBalanceDefinition. Was " + processor.getClass().getName());
        }
        LoadBalanceDefinition node = (LoadBalanceDefinition)processor;
        this.setInheritErrorHandler((Boolean)Objects.getField(node, "inheritErrorHandler"));
        this.setRef(node.getRef());
        this.setLoadBalancerType(node.getLoadBalancerType());
    }
}

