/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.ExpressionPropertyDescriptor;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;

public class Delay
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "Delay.Expression";
    public static final String PROPERTY_EXECUTORSERVICEREF = "Delay.ExecutorServiceRef";
    public static final String PROPERTY_ASYNCDELAYED = "Delay.AsyncDelayed";
    public static final String PROPERTY_CALLERRUNSWHENREJECTED = "Delay.CallerRunsWhenRejected";
    private ExpressionDefinition expression;
    private String executorServiceRef;
    private Boolean asyncDelayed;
    private Boolean callerRunsWhenRejected;

    public Delay() {
    }

    public Delay(DelayDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "generic.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "delayEIP";
    }

    @Override
    public String getCategoryName() {
        return "Control Flow";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        if (!this.isSame(oldValue, expression)) {
            this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
        }
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        String oldValue = this.executorServiceRef;
        this.executorServiceRef = executorServiceRef;
        if (!this.isSame(oldValue, executorServiceRef)) {
            this.firePropertyChange(PROPERTY_EXECUTORSERVICEREF, oldValue, executorServiceRef);
        }
    }

    public Boolean getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(Boolean asyncDelayed) {
        Boolean oldValue = this.asyncDelayed;
        this.asyncDelayed = asyncDelayed;
        if (!this.isSame(oldValue, asyncDelayed)) {
            this.firePropertyChange(PROPERTY_ASYNCDELAYED, oldValue, asyncDelayed);
        }
    }

    public Boolean getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(Boolean callerRunsWhenRejected) {
        Boolean oldValue = this.callerRunsWhenRejected;
        this.callerRunsWhenRejected = callerRunsWhenRejected;
        if (!this.isSame(oldValue, callerRunsWhenRejected)) {
            this.firePropertyChange(PROPERTY_CALLERRUNSWHENREJECTED, oldValue, callerRunsWhenRejected);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelDelayExpression);
        TextPropertyDescriptor descExecutorServiceRef = new TextPropertyDescriptor((Object)PROPERTY_EXECUTORSERVICEREF, Messages.propertyLabelDelayExecutorServiceRef);
        BooleanPropertyDescriptor descAsyncDelayed = new BooleanPropertyDescriptor((Object)PROPERTY_ASYNCDELAYED, Messages.propertyLabelDelayAsyncDelayed);
        BooleanPropertyDescriptor descCallerRunsWhenRejected = new BooleanPropertyDescriptor((Object)PROPERTY_CALLERRUNSWHENREJECTED, Messages.propertyLabelDelayCallerRunsWhenRejected);
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_EXECUTORSERVICEREF, (PropertyDescriptor)descExecutorServiceRef);
        descriptors.put(PROPERTY_ASYNCDELAYED, (PropertyDescriptor)descAsyncDelayed);
        descriptors.put(PROPERTY_CALLERRUNSWHENREJECTED, (PropertyDescriptor)descCallerRunsWhenRejected);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
            return;
        }
        if (PROPERTY_EXECUTORSERVICEREF.equals(id)) {
            this.setExecutorServiceRef(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_ASYNCDELAYED.equals(id)) {
            this.setAsyncDelayed(Objects.convertTo(value, Boolean.class));
            return;
        }
        if (PROPERTY_CALLERRUNSWHENREJECTED.equals(id)) {
            this.setCallerRunsWhenRejected(Objects.convertTo(value, Boolean.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_EXECUTORSERVICEREF.equals(id)) {
            return this.getExecutorServiceRef();
        }
        if (PROPERTY_ASYNCDELAYED.equals(id)) {
            return this.getAsyncDelayed();
        }
        if (PROPERTY_CALLERRUNSWHENREJECTED.equals(id)) {
            return this.getCallerRunsWhenRejected();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        DelayDefinition answer = new DelayDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setExecutorServiceRef(this.toXmlPropertyValue(PROPERTY_EXECUTORSERVICEREF, this.getExecutorServiceRef()));
        answer.setAsyncDelayed(this.toXmlPropertyValue(PROPERTY_ASYNCDELAYED, this.getAsyncDelayed()));
        answer.setCallerRunsWhenRejected(this.toXmlPropertyValue(PROPERTY_CALLERRUNSWHENREJECTED, this.getCallerRunsWhenRejected()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return DelayDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof DelayDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof DelayDefinition. Was " + processor.getClass().getName());
        }
        DelayDefinition node = (DelayDefinition)processor;
        this.setExpression(node.getExpression());
        this.setExecutorServiceRef(node.getExecutorServiceRef());
        this.setAsyncDelayed(node.getAsyncDelayed());
        this.setCallerRunsWhenRejected(node.getCallerRunsWhenRejected());
    }
}

