/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;

public class Bean
extends AbstractNode {
    public static final String PROPERTY_REF = "Bean.Ref";
    public static final String PROPERTY_METHOD = "Bean.Method";
    public static final String PROPERTY_BEANTYPE = "Bean.BeanType";
    public static final String PROPERTY_CACHE = "Bean.Cache";
    public static final String PROPERTY_MULTIPARAMETERARRAY = "Bean.MultiParameterArray";
    private String ref;
    private String method;
    private String beanType;
    private Boolean cache;
    private Boolean multiParameterArray;

    public Bean() {
    }

    public Bean(BeanDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "bean.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "beanComp";
    }

    @Override
    public String getCategoryName() {
        return "Components";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        String oldValue = this.ref;
        this.ref = ref;
        if (!this.isSame(oldValue, ref)) {
            this.firePropertyChange(PROPERTY_REF, oldValue, ref);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        String oldValue = this.method;
        this.method = method;
        if (!this.isSame(oldValue, method)) {
            this.firePropertyChange(PROPERTY_METHOD, oldValue, method);
        }
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        String oldValue = this.beanType;
        this.beanType = beanType;
        if (!this.isSame(oldValue, beanType)) {
            this.firePropertyChange(PROPERTY_BEANTYPE, oldValue, beanType);
        }
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        Boolean oldValue = this.cache;
        this.cache = cache;
        if (!this.isSame(oldValue, cache)) {
            this.firePropertyChange(PROPERTY_CACHE, oldValue, cache);
        }
    }

    public Boolean getMultiParameterArray() {
        return this.multiParameterArray;
    }

    public void setMultiParameterArray(Boolean multiParameterArray) {
        Boolean oldValue = this.multiParameterArray;
        this.multiParameterArray = multiParameterArray;
        if (!this.isSame(oldValue, multiParameterArray)) {
            this.firePropertyChange(PROPERTY_MULTIPARAMETERARRAY, oldValue, multiParameterArray);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descRef = new TextPropertyDescriptor((Object)PROPERTY_REF, Messages.propertyLabelBeanRef);
        TextPropertyDescriptor descMethod = new TextPropertyDescriptor((Object)PROPERTY_METHOD, Messages.propertyLabelBeanMethod);
        TextPropertyDescriptor descBeanType = new TextPropertyDescriptor((Object)PROPERTY_BEANTYPE, Messages.propertyLabelBeanBeanType);
        BooleanPropertyDescriptor descCache = new BooleanPropertyDescriptor((Object)PROPERTY_CACHE, Messages.propertyLabelBeanCache);
        BooleanPropertyDescriptor descMultiParameterArray = new BooleanPropertyDescriptor((Object)PROPERTY_MULTIPARAMETERARRAY, Messages.propertyLabelBeanMultiParameterArray);
        descriptors.put(PROPERTY_REF, (PropertyDescriptor)descRef);
        descriptors.put(PROPERTY_METHOD, (PropertyDescriptor)descMethod);
        descriptors.put(PROPERTY_BEANTYPE, (PropertyDescriptor)descBeanType);
        descriptors.put(PROPERTY_CACHE, (PropertyDescriptor)descCache);
        descriptors.put(PROPERTY_MULTIPARAMETERARRAY, (PropertyDescriptor)descMultiParameterArray);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_REF.equals(id)) {
            this.setRef(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_METHOD.equals(id)) {
            this.setMethod(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_BEANTYPE.equals(id)) {
            this.setBeanType(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_CACHE.equals(id)) {
            this.setCache(Objects.convertTo(value, Boolean.class));
            return;
        }
        if (PROPERTY_MULTIPARAMETERARRAY.equals(id)) {
            this.setMultiParameterArray(Objects.convertTo(value, Boolean.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_REF.equals(id)) {
            return this.getRef();
        }
        if (PROPERTY_METHOD.equals(id)) {
            return this.getMethod();
        }
        if (PROPERTY_BEANTYPE.equals(id)) {
            return this.getBeanType();
        }
        if (PROPERTY_CACHE.equals(id)) {
            return this.getCache();
        }
        if (PROPERTY_MULTIPARAMETERARRAY.equals(id)) {
            return this.getMultiParameterArray();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        BeanDefinition answer = new BeanDefinition();
        answer.setRef(this.toXmlPropertyValue(PROPERTY_REF, this.getRef()));
        answer.setMethod(this.toXmlPropertyValue(PROPERTY_METHOD, this.getMethod()));
        answer.setBeanType(this.toXmlPropertyValue(PROPERTY_BEANTYPE, this.getBeanType()));
        answer.setCache(this.toXmlPropertyValue(PROPERTY_CACHE, this.getCache()));
        answer.setMultiParameterArray(this.toXmlPropertyValue(PROPERTY_MULTIPARAMETERARRAY, this.getMultiParameterArray()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return BeanDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof BeanDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof BeanDefinition. Was " + processor.getClass().getName());
        }
        BeanDefinition node = (BeanDefinition)processor;
        this.setRef(node.getRef());
        this.setMethod(node.getMethod());
        this.setBeanType(node.getBeanType());
        this.setCache(node.getCache());
        this.setMultiParameterArray(node.getMultiParameterArray());
    }
}

