/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model;

import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.LanguageExpression;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.ExpressionPropertyDescriptor;
import org.fusesource.ide.commons.util.Strings;

public class ExpressionCellEditor
extends CellEditor {
    private Label labelExpression;
    private Button btnOpenExpressionDialog;
    private FileDialog expressionDialog;
    private String expression;
    private String language;
    private LanguageExpression value = new LanguageExpression();
    public static final String[] LANGUAGES = new String[]{"el", "groovy", "js", "ruby", "simple", "xpath", "xquery"};

    public ExpressionCellEditor(ExpressionPropertyDescriptor expressionPropertyDescriptor, Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite parent) {
        RowLayout layout = new RowLayout(256);
        layout.spacing = 10;
        layout.pack = false;
        layout.center = true;
        layout.justify = true;
        layout.fill = true;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        this.labelExpression = new Label(composite, 0);
        this.labelExpression.setText("");
        this.btnOpenExpressionDialog = new Button(composite, 8);
        this.btnOpenExpressionDialog.setText("...");
        this.btnOpenExpressionDialog.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionCellEditor.this.expressionDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                ExpressionCellEditor.this.expression = ExpressionCellEditor.this.expressionDialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    protected Object doGetValue() {
        this.value.setExpression(this.expression);
        this.value.setLanguage(this.language);
        return this.value;
    }

    protected String toString(Object value) {
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    protected void doSetFocus() {
        this.btnOpenExpressionDialog.setFocus();
    }

    protected void doSetValue(Object value) {
        if (value instanceof ExpressionDefinition) {
            ExpressionDefinition expr = (ExpressionDefinition)value;
            this.value = new LanguageExpression(expr.getLanguage(), expr.getExpression());
            Strings.getOrElse((Object)this.value.getLanguage());
        } else {
            Activator.getLogger().warning("Bad value ignored: " + value);
        }
    }
}

