/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model;

import java.util.Map;
import java.util.Set;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ToDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.CamelModelHelper;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.commons.util.XmlUtilities;

public class Endpoint
extends AbstractNode {
    public static final String PROPERTY_URI = "Endpoint.Uri";
    public static final String PROPERTY_PATTERN = "Endpoint.Pattern";
    private static final String ICON = "endpoint.png";
    private String uri = "";
    private String pattern = null;

    public Endpoint() {
    }

    public static Endpoint newInstance(ToDefinition definition, RouteContainer parent) {
        if (parent instanceof RouteSupport) {
            RouteSupport route = (RouteSupport)parent;
            return route.getOrCreateEndpoint(definition, parent);
        }
        return new Endpoint(definition, parent);
    }

    public Endpoint(ToDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    public Endpoint(FromDefinition definition, RouteContainer parent) {
        super(parent);
        this.setId(definition.getId());
        this.setDescription(definition.getDescriptionText());
        this.setUri(CamelModelHelper.getUri(definition));
    }

    public Endpoint(String uri) {
        this.uri = uri;
        this.uri = XmlUtilities.unescape((String)uri);
    }

    public Endpoint(Endpoint endpoint) {
        this(endpoint.uri);
        this.setId(endpoint.getId());
        this.setDescription(endpoint.getDescription());
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        String oldUri = this.uri;
        this.uri = XmlUtilities.unescape((String)uri);
        if (!this.isSame(uri, oldUri)) {
            this.clearImages();
            this.firePropertyChange(PROPERTY_URI, oldUri, uri);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        String oldPattern = this.pattern;
        this.pattern = pattern;
        if (!this.isSame(pattern, oldPattern)) {
            this.firePropertyChange(PROPERTY_PATTERN, oldPattern, pattern);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getIconName() {
        String u = this.getUri();
        if (u == null || u.trim().length() <= 0) return ICON;
        String scheme = null;
        if (u.startsWith("ref:")) {
            String refId = u.substring(u.indexOf(":") + 1);
            RouteContainer c = this.getParent().getParent();
            String refUri = c.getCamelContextEndpointUris().get(refId);
            if (refUri == null) return ICON;
            scheme = refUri.substring(0, refUri.indexOf(":") + 1);
        } else {
            scheme = u.substring(0, u.indexOf(":") + 1);
        }
        if (scheme.startsWith("drools:")) {
            return "endpointDrools.png";
        }
        if (scheme.startsWith("jms:") || scheme.startsWith("activemq") || scheme.startsWith("mq") || scheme.startsWith("sjms")) {
            return "endpointQueue.png";
        }
        if (scheme.startsWith("file:") || scheme.startsWith("ftp") || scheme.startsWith("sftp") || scheme.startsWith("jcr") || scheme.startsWith("scp")) {
            return "endpointFolder.png";
        }
        if (scheme.startsWith("log:") || scheme.startsWith("hdfs") || scheme.startsWith("paxlogging")) {
            return "endpointFile.png";
        }
        if (scheme.startsWith("timer:") || scheme.startsWith("quartz")) {
            return "endpointTimer.png";
        }
        if (scheme.startsWith("elasticsearch:") || scheme.startsWith("hazelcast:") || scheme.startsWith("hibernate:") || scheme.startsWith("jpa:") || scheme.startsWith("jdbc:") || scheme.startsWith("sql:") || scheme.startsWith("ibatis:") || scheme.startsWith("mybatis:") || scheme.startsWith("javaspace:") || scheme.startsWith("jcr:") || scheme.startsWith("ldap:") || scheme.startsWith("mongodb:") || scheme.startsWith("zookeeper:")) {
            return "endpointRepository.png";
        }
        if (scheme.startsWith("twitter:")) {
            return "endpointTwitter.png";
        }
        if (scheme.startsWith("weather:")) {
            return "endpointWeather.png";
        }
        if (scheme.startsWith("sap-netweaver:")) {
            return "endpointSAPNetweaver.png";
        }
        if (scheme.startsWith("sap:")) {
            return "endpointSAP.png";
        }
        if (scheme.startsWith("salesforce:")) {
            return "endpointSalesforce.png";
        }
        if (scheme.startsWith("facebook:")) {
            return "endpointFacebook.png";
        }
        if (!scheme.startsWith("dozer:")) return ICON;
        return "endpointDozer.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "endpoint";
    }

    @Override
    public String getCategoryName() {
        return "Components";
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor desc = new TextPropertyDescriptor((Object)PROPERTY_URI, Messages.propertyLabelEndpointUri);
        desc.setValidator(DEFAULT_STRING_VALIDATOR);
        descriptors.put(PROPERTY_URI, (PropertyDescriptor)desc);
        desc = new TextPropertyDescriptor((Object)PROPERTY_PATTERN, Messages.propertyLabelEndpointPattern);
        desc.setValidator(DEFAULT_STRING_VALIDATOR);
        descriptors.put(PROPERTY_PATTERN, (PropertyDescriptor)desc);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_URI.equals(id)) {
            this.setUri((String)value);
        } else if (PROPERTY_PATTERN.equals(id)) {
            this.setPattern((String)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_URI.equals(id)) {
            return this.getUri();
        }
        if (PROPERTY_PATTERN.equals(id)) {
            return this.getPattern();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        ToDefinition answer = new ToDefinition();
        CamelModelHelper.setUri(answer, this);
        CamelModelHelper.setExchangePattern(answer, this);
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public void savePropertiesToCamelDefinition(ProcessorDefinition processor) {
        super.savePropertiesToCamelDefinition(processor);
        if (!(processor instanceof ToDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ToDefinition. Was " + processor.getClass().getName());
        }
        ToDefinition node = (ToDefinition)processor;
        CamelModelHelper.setUri(node, this);
        CamelModelHelper.setExchangePattern(node, this);
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof ToDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ToDefinition. Was " + processor.getClass().getName());
        }
        ToDefinition node = (ToDefinition)processor;
        String value = CamelModelHelper.getUri(node);
        this.setUri(value);
        value = CamelModelHelper.getExchangePattern(node);
        this.setPattern(value);
    }

    public void populateCamelDefinition(FromDefinition from) {
        this.setId(from.getId());
        this.setDescription(from.getDescriptionText());
    }

    @Override
    public void appendEndpointUris(Set<String> uris) {
        String trimmed;
        if (this.uri != null && (trimmed = this.uri.trim()).length() > 0) {
            uris.add(trimmed);
        }
        super.appendEndpointUris(uris);
    }

    public boolean isInputEndpoint() {
        return !this.getSourceConnections().isEmpty() && this.getTargetConnections().isEmpty();
    }

    public boolean isOutputEndpoint() {
        return this.getSourceConnections().isEmpty() && !this.getTargetConnections().isEmpty();
    }

    public String buildUri() {
        return this.uri;
    }
}

