/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.AbstractTableLabelProvider;
import org.teiid.designer.ui.common.wizard.AbstractSelectionWizard;

final class WizardSelectionPage
extends WizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(WizardSelectionPage.class);
    private static final String TITLE = WizardSelectionPage.getString("title");
    private static final String INITIAL_MESSAGE = WizardSelectionPage.getString("initialMessage");
    private static final String SELECT_LABEL = WizardSelectionPage.getString("selectLabel");
    IConfigurationElement[] elems;
    private ViewerSorter sorter;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public WizardSelectionPage(IConfigurationElement[] elements, ViewerSorter sorter) {
        super(WizardSelectionPage.class.getSimpleName(), TITLE, null);
        CoreArgCheck.isNotNull((Object)elements);
        this.elems = elements;
        this.sorter = sorter;
        this.setMessage(INITIAL_MESSAGE);
    }

    public void createControl(Composite parent) {
        Composite pg = WidgetFactory.createPanel(parent);
        this.setControl((Control)pg);
        Label label = new Label(pg, 0);
        label.setText(SELECT_LABEL);
        TableViewer viewer = WidgetFactory.createTableViewer(pg);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return WizardSelectionPage.this.elems;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new AbstractTableLabelProvider(){

            @Override
            public Image getColumnImage(Object element, int column) {
                try {
                    AbstractSelectionWizard wizard = (AbstractSelectionWizard)WizardSelectionPage.this.getWizard();
                    String icon = wizard.getSelectedWizardIcon((IConfigurationElement)element);
                    if (icon != null) {
                        URL baseUrl = Platform.getBundle((String)((IConfigurationElement)element).getDeclaringExtension().getNamespaceIdentifier()).getEntry("/");
                        URL url = new URL(baseUrl, icon);
                        return ImageDescriptor.createFromURL((URL)url).createImage();
                    }
                }
                catch (MalformedURLException err) {
                    Util.log((Throwable)err);
                }
                return ImageDescriptor.getMissingImageDescriptor().createImage();
            }

            public String getColumnText(Object element, int column) {
                AbstractSelectionWizard wizard = (AbstractSelectionWizard)WizardSelectionPage.this.getWizard();
                return wizard.getSelectedWizardName((IConfigurationElement)element);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ((AbstractSelectionWizard)WizardSelectionPage.this.getWizard()).setSelectedWizard(sel);
                if (sel != null && !sel.isEmpty()) {
                    IConfigurationElement elem = (IConfigurationElement)sel.getFirstElement();
                    IConfigurationElement[] children = elem.getChildren("description");
                    if (children.length >= 1) {
                        WizardSelectionPage.this.setMessage(children[0].getValue());
                    } else {
                        WizardSelectionPage.this.setMessage("");
                    }
                }
            }
        });
        if (this.sorter != null) {
            viewer.setSorter(this.sorter);
        }
        viewer.setInput((Object)this);
        viewer.setSelection((ISelection)new StructuredSelection(viewer.getElementAt(0)));
    }

    public boolean canFlipToNextPage() {
        return ((AbstractSelectionWizard)this.getWizard()).getSelectedWizard() != null;
    }
}

