/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class StatusLabel
extends Composite {
    private static final int DEFAULT_IMAGE_WIDTH = 16;
    private static final int DEFAULT_ROWS = 2;
    private static final Image ERROR_IMAGE;
    private static final Image INFO_IMAGE;
    private static final Image WARNING_IMAGE;
    private int rows = 2;
    private Label lblImage;
    private Label lblText;

    static {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ERROR_IMAGE = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
        INFO_IMAGE = sharedImages.getImage("IMG_OBJS_INFO_TSK");
        WARNING_IMAGE = sharedImages.getImage("IMG_OBJS_WARN_TSK");
    }

    public StatusLabel(Composite theParent) {
        super(theParent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 3;
        this.setLayout((Layout)layout);
        this.lblImage = new Label((Composite)this, 0);
        GridData gd = new GridData(2);
        gd.widthHint = 16;
        this.lblImage.setLayoutData((Object)gd);
        this.lblText = new Label((Composite)this, 64);
        this.lblText.setLayoutData((Object)new GridData(1808));
        this.setRows(2);
    }

    public void setLayout(Layout theLayout) {
        if (theLayout instanceof GridLayout) {
            super.setLayout(theLayout);
        }
    }

    public void setLayoutData(Object theLayoutData) {
        if (theLayoutData instanceof GridData) {
            super.setLayoutData(theLayoutData);
        }
    }

    public Image getImage() {
        return this.lblImage.getImage();
    }

    public int getRows() {
        return this.rows;
    }

    public String getText() {
        return this.lblText.getText();
    }

    public void setImage(Image theImage) {
        this.lblImage.setImage(theImage);
    }

    public void setRows(int theRows) {
        if (theRows > 0) {
            GridData gd = (GridData)this.lblText.getLayoutData();
            gd.heightHint = theRows * this.lblText.computeSize((int)-1, (int)-1).y;
        }
    }

    public void setText(String theText) {
        this.lblText.setText(theText);
    }

    public void setText(String theText, int severity) {
        if (severity == 4) {
            this.setImage(ERROR_IMAGE);
        } else if (severity == 2) {
            this.setImage(WARNING_IMAGE);
        } else if (severity == 1) {
            this.setImage(INFO_IMAGE);
        }
        this.lblText.setText(theText);
    }
}

