/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExtendedTitleAreaDialog
extends TitleAreaDialog {
    protected static final String SHELL_X = "shellX";
    protected static final String SHELL_Y = "shellY";
    protected static final String SHELL_WIDTH = "shellWidth";
    protected static final String SHELL_HEIGHT = "shellHeight";
    private AbstractUIPlugin plugin;
    private boolean persistGeometry = true;
    private int initialWidthPercentage = -1;
    private int initialHeightPercentage = -1;

    public ExtendedTitleAreaDialog(Shell theParentShell, AbstractUIPlugin thePlugin) {
        super(theParentShell);
        this.plugin = thePlugin;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setInitialSizeRelativeToScreen(int theWidthPercentage, int theHeightPercentage) {
        this.initialWidthPercentage = theWidthPercentage < 1 || theWidthPercentage > 100 ? 50 : theWidthPercentage;
        this.initialHeightPercentage = theHeightPercentage < 1 || theHeightPercentage > 100 ? 50 : theHeightPercentage;
    }

    public boolean close() {
        if (this.persistGeometry) {
            this.persistShellGeometry();
        }
        return super.close();
    }

    protected String getDialogSettingsSectionName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = this.plugin.getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected Point getInitialLocation(Point theInitialLocation) {
        Point result = null;
        if (this.persistGeometry) {
            IDialogSettings settings = this.getDialogSettings();
            try {
                int x = settings.getInt(SHELL_X);
                int y = settings.getInt(SHELL_Y);
                result = new Point(x, y);
            }
            catch (NumberFormatException numberFormatException) {}
            if (result == null) {
                result = this.getInitialLocationFromRelativeScreen();
            }
        } else {
            result = this.getInitialLocationFromRelativeScreen();
        }
        return result == null ? super.getInitialLocation(theInitialLocation) : result;
    }

    protected Point getInitialSize() {
        Point result = null;
        if (this.persistGeometry) {
            IDialogSettings settings = this.getDialogSettings();
            try {
                int x = settings.getInt(SHELL_WIDTH);
                int y = settings.getInt(SHELL_HEIGHT);
                result = new Point(x, y);
            }
            catch (NumberFormatException numberFormatException) {}
            if (result == null) {
                result = this.getInitialSizeFromRelativeScreen();
            }
        } else {
            result = this.getInitialSizeFromRelativeScreen();
        }
        return result == null ? super.getInitialSize() : result;
    }

    protected void persistShellGeometry() {
        Point shellLocation = this.getShell().getLocation();
        Point shellSize = this.getShell().getSize();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SHELL_X, shellLocation.x);
        settings.put(SHELL_Y, shellLocation.y);
        settings.put(SHELL_WIDTH, shellSize.x);
        settings.put(SHELL_HEIGHT, shellSize.y);
    }

    protected Point getInitialSizeFromRelativeScreen() {
        Point result = null;
        if (this.initialWidthPercentage >= 1 && this.initialWidthPercentage <= 100 && this.initialHeightPercentage >= 1 && this.initialHeightPercentage <= 100) {
            Shell shell = this.getShell();
            Rectangle bounds = shell.getDisplay().getClientArea();
            int scaledWidth = bounds.width * this.initialWidthPercentage / 100;
            int scaledHeight = bounds.height * this.initialHeightPercentage / 100;
            result = new Point(scaledWidth, scaledHeight);
        }
        return result;
    }

    protected Point getInitialLocationFromRelativeScreen() {
        Point result = null;
        if (this.initialWidthPercentage >= 1 && this.initialWidthPercentage <= 100 && this.initialHeightPercentage >= 1 && this.initialHeightPercentage <= 100) {
            Shell shell = this.getShell();
            Rectangle bounds = shell.getDisplay().getClientArea();
            int scaledWidth = bounds.width * this.initialWidthPercentage / 100;
            int scaledHeight = bounds.height * this.initialHeightPercentage / 100;
            int excessX = bounds.width - scaledWidth;
            int excessY = bounds.height - scaledHeight;
            int x = bounds.x + excessX / 2;
            int y = bounds.y + excessY / 2;
            result = new Point(x, y);
        }
        return result;
    }
}

