/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.DefaultTreeViewerController;
import org.teiid.designer.ui.common.widget.IListPanelController;
import org.teiid.designer.ui.common.widget.ITreeViewerController;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.widget.ListPanel;
import org.teiid.designer.ui.common.widget.WrappingLabel;

public final class WidgetFactory
implements InternalUiConstants.Widgets {
    private static final Color[] TITLE_SELECTION_GRADIENT = new Color[]{UiUtil.getSystemColor(31), UiUtil.getSystemColor(32)};
    private static final int[] TITLE_SELECTION_GRADIENT_PERCENTAGES = new int[]{100};
    private static final Color TITLE_SELECTION_FOREGROUND = UiUtil.getSystemColor(30);
    public static final char PASSWORD_ECHO_CHAR = '*';
    public static final int NO_DEFAULTS = 0x40000000;

    public static Button createButton(Composite parent, int gridStyle) {
        return WidgetFactory.createButton(parent, null, gridStyle, 1, 8);
    }

    public static Button createButton(Composite parent, String name) {
        return WidgetFactory.createButton(parent, name, 0, 1, 8);
    }

    public static Button createButton(Composite parent, String name, int gridStyle) {
        return WidgetFactory.createButton(parent, name, gridStyle, 1, 8);
    }

    public static Button createButton(Composite parent, String name, int gridStyle, int span) {
        return WidgetFactory.createButton(parent, name, gridStyle, span, 8);
    }

    public static Button createButton(Composite parent, String name, int gridStyle, int span, int style) {
        Button button = new Button(parent, style);
        if (name != null) {
            button.setText(name);
        }
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        button.setLayoutData((Object)gridData);
        return button;
    }

    public static Button createCheckBox(Composite parent) {
        return WidgetFactory.createCheckBox(parent, null);
    }

    public static Button createCheckBox(Composite parent, String name) {
        return WidgetFactory.createCheckBox(parent, name, 0);
    }

    public static Button createCheckBox(Composite parent, int gridStyle) {
        return WidgetFactory.createCheckBox(parent, null, gridStyle);
    }

    public static Button createCheckBox(Composite parent, String name, int gridStyle) {
        return WidgetFactory.createCheckBox(parent, name, gridStyle, 1, false);
    }

    public static Button createCheckBox(Composite parent, String name, boolean selected) {
        return WidgetFactory.createCheckBox(parent, name, 0, selected);
    }

    public static Button createCheckBox(Composite parent, String name, int gridStyle, boolean selected) {
        return WidgetFactory.createCheckBox(parent, name, gridStyle, 1, selected);
    }

    public static Button createCheckBox(Composite parent, String name, int gridStyle, int span) {
        return WidgetFactory.createCheckBox(parent, name, gridStyle, span, false);
    }

    public static Button createCheckBox(Composite parent, String name, int gridStyle, int span, boolean selected) {
        Button button = WidgetFactory.createButton(parent, name, gridStyle, span, 32);
        button.setSelection(selected);
        return button;
    }

    public static Combo createCombo(Composite parent, int style) {
        return WidgetFactory.createCombo(parent, style, 256);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle) {
        return WidgetFactory.createCombo(parent, style, gridStyle, 1);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, int span) {
        return WidgetFactory.createCombo(parent, style, gridStyle, span, null, null);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, int span, List items, ILabelProvider provider) {
        return WidgetFactory.createCombo(parent, style, gridStyle, span, items, provider, true);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, int span, List items, ILabelProvider provider, boolean sort) {
        return WidgetFactory.createCombo(parent, style, gridStyle, span, items, null, provider, sort);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, List items) {
        return WidgetFactory.createCombo(parent, style, gridStyle, items, null);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, Object[] items) {
        return WidgetFactory.createCombo(parent, style, gridStyle, items, null);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, int span, Object[] items) {
        return WidgetFactory.createCombo(parent, style, gridStyle, span, items == null ? null : Arrays.asList(items), null);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, Object[] items, Object selection) {
        return WidgetFactory.createCombo(parent, style, gridStyle, items == null ? null : Arrays.asList(items), selection);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, List items, Object selection) {
        return WidgetFactory.createCombo(parent, style, gridStyle, items, selection, null);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, List items, ILabelProvider provider) {
        return WidgetFactory.createCombo(parent, style, gridStyle, items, provider, true);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, List items, ILabelProvider provider, boolean sort) {
        return WidgetFactory.createCombo(parent, style, gridStyle, items, null, provider, sort);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, List items, Object selection, ILabelProvider provider) {
        return WidgetFactory.createCombo(parent, style, gridStyle, items, selection, provider, true);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, List items, Object selection, ILabelProvider provider, boolean sort) {
        return WidgetFactory.createCombo(parent, style, gridStyle, 1, items, selection, provider, sort);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, ILabelProvider provider) {
        return WidgetFactory.createCombo(parent, style, gridStyle, null, null, provider);
    }

    public static Combo createCombo(Composite parent, int style, int gridStyle, int span, List items, Object selection, ILabelProvider provider, boolean sort) {
        CoreArgCheck.isNotNull((Object)parent);
        Combo combo = new Combo(parent, style | 0x800);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        combo.setLayoutData((Object)gridData);
        if (items != null) {
            WidgetUtil.setComboItems(combo, items, provider, sort);
        }
        if (selection != null) {
            WidgetUtil.setComboText(combo, selection, provider, !WidgetUtil.hasStyle((Widget)combo, 8));
        }
        return combo;
    }

    public static FormText createFormText(final Composite parent, FormToolkit toolkit, String html, IHyperlinkListener listener) {
        FormText formText = toolkit.createFormText(parent, true);
        formText.setHyperlinkSettings(new HyperlinkSettings(parent.getDisplay()){

            public Cursor getHyperlinkCursor() {
                if (this.getHyperlinkUnderlineMode() == 1) {
                    return parent.getDisplay().getSystemCursor(0);
                }
                return super.getHyperlinkCursor();
            }
        });
        formText.setText(html, true, false);
        formText.addHyperlinkListener(listener);
        return formText;
    }

    public static Group createSimpleGroup(Composite parent, String name) {
        Group group = new Group(parent, 2048);
        FillLayout fillLayout = new FillLayout();
        if (name != null) {
            group.setText(name);
            fillLayout.marginHeight = 10;
        }
        group.setLayout((Layout)fillLayout);
        group.setFont(JFaceResources.getBannerFont());
        return group;
    }

    public static Group createGroup(Composite parent, String name) {
        return WidgetFactory.createGroup(parent, name, 0);
    }

    public static Group createGroup(Composite parent, int gridStyle) {
        return WidgetFactory.createGroup(parent, null, gridStyle);
    }

    public static Group createGroup(Composite parent, String name, int gridStyle) {
        return WidgetFactory.createGroup(parent, name, gridStyle, 1);
    }

    public static Group createGroup(Composite parent, String name, int gridStyle, int span) {
        return WidgetFactory.createGroup(parent, name, gridStyle, span, 1);
    }

    public static Group createGroup(Composite parent, String name, int gridStyle, int span, int columns) {
        Group group = new Group(parent, 0);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        group.setLayoutData((Object)gridData);
        GridLayoutFactory gridLayoutFactory = GridLayoutFactory.fillDefaults().numColumns(columns).equalWidth(false);
        Font bannerFont = JFaceResources.getBannerFont();
        group.setFont(bannerFont);
        if (name != null) {
            gridLayoutFactory = gridLayoutFactory.margins(2, 10);
            group.setText(name);
        }
        gridLayoutFactory.applyTo((Composite)group);
        return group;
    }

    public static Label createLabel(Composite parent) {
        return WidgetFactory.createLabel(parent, 2);
    }

    public static Label createLabel(Composite parent, int gridStyle) {
        return WidgetFactory.createLabel(parent, gridStyle, 1);
    }

    public static Label createLabel(Composite parent, int gridStyle, int span) {
        return WidgetFactory.createLabel(parent, gridStyle, span, null);
    }

    public static Label createLabel(Composite parent, int gridStyle, int span, String text) {
        return WidgetFactory.createLabel(parent, gridStyle, span, text, 0);
    }

    public static Label createLabel(Composite parent, int gridStyle, int span, String text, int style) {
        return WidgetFactory.createLabel(parent, gridStyle, span, text, null, style);
    }

    public static Label createLabel(Composite parent, int gridStyle, String text) {
        return WidgetFactory.createLabel(parent, gridStyle, 1, text);
    }

    public static Label createLabel(Composite parent, int gridStyle, String text, int style) {
        return WidgetFactory.createLabel(parent, gridStyle, 1, text, style);
    }

    public static Label createLabel(Composite parent, int gridStyle, Image image, int style) {
        return WidgetFactory.createLabel(parent, gridStyle, 1, null, image, style);
    }

    public static Label createLabel(Composite parent, String text) {
        return WidgetFactory.createLabel(parent, text, 0);
    }

    public static Label createLabel(Composite parent, String text, int style) {
        return WidgetFactory.createLabel(parent, text, null, style);
    }

    public static Label createLabel(Composite parent, String text, Image image, int style) {
        return WidgetFactory.createLabel(parent, 2, 1, text, image, style);
    }

    public static Label createLabel(Composite parent, Image image) {
        return WidgetFactory.createLabel(parent, image, 0);
    }

    public static Label createLabel(Composite parent, Image image, int style) {
        return WidgetFactory.createLabel(parent, 2, 1, null, image, style);
    }

    public static Label createLabel(Composite parent, int gridStyle, int span, String text, Image image, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setImage(image);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        label.setLayoutData(gridData);
        return label;
    }

    public static ListPanel createListPanel(Composite parent, String title, IListPanelController controller) {
        return new ListPanel(parent, title, controller);
    }

    public static WizardDialog createOnePageWizardDialog(Shell shell, IWizard wizard) {
        CoreArgCheck.isNotNull((Object)shell);
        CoreArgCheck.isNotNull((Object)wizard);
        WizardDialog dlg = new WizardDialog(shell, wizard){

            public void create() {
                this.setShellStyle(this.getShellStyle() | 0x10);
                super.create();
                this.getShell().getDefaultButton().setText(OK_LABEL);
                this.updateSize(this.getWizard().getStartingPage());
            }
        };
        return dlg;
    }

    public static Composite createPanel(Composite parent) {
        return WidgetFactory.createPanel(parent, 0);
    }

    public static Composite createPanel(Composite parent, int style) {
        return WidgetFactory.createPanel(parent, style, 0);
    }

    public static Composite createPanel(Composite parent, int style, int gridStyle) {
        return WidgetFactory.createPanel(parent, style, gridStyle, 1);
    }

    public static Composite createPanel(Composite parent, int style, int gridStyle, int span) {
        return WidgetFactory.createPanel(parent, style, gridStyle, span, 1);
    }

    public static Composite createPanel(Composite parent, int style, int gridStyle, int span, int columns) {
        Composite panel = new Composite(parent, style);
        WidgetUtil.initializePanel(panel, gridStyle, span, columns);
        return panel;
    }

    public static Text createPasswordField(Composite parent) {
        return WidgetFactory.createPasswordField(parent, 768, 1);
    }

    public static Text createPasswordField(Composite parent, int gridStyle, int span) {
        Text text = WidgetFactory.createTextField(parent, gridStyle, span);
        text.setEchoChar('*');
        return text;
    }

    public static Button createRadioButton(Composite parent, String name) {
        return WidgetFactory.createRadioButton(parent, name, false);
    }

    public static Button createRadioButton(Composite parent, String name, boolean selected) {
        return WidgetFactory.createRadioButton(parent, name, 0, 1, selected);
    }

    public static Button createRadioButton(Composite parent, String name, int gridStyle, int span, boolean selected) {
        Button button = WidgetFactory.createButton(parent, name, gridStyle, span, 16);
        button.setSelection(selected);
        return button;
    }

    public static SashForm createSplitter(Composite parent) {
        return WidgetFactory.createSplitter(parent, 256);
    }

    public static SashForm createSplitter(Composite parent, int style) {
        return WidgetFactory.createSplitter(parent, style, 1808);
    }

    public static SashForm createSplitter(Composite parent, int style, int gridStyle) {
        return WidgetFactory.createSplitter(parent, style, gridStyle, 1);
    }

    public static SashForm createSplitter(Composite parent, int style, int gridStyle, int span) {
        SashForm splitter = new SashForm(parent, style);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        splitter.setLayoutData((Object)gridData);
        return splitter;
    }

    public static CTabItem createTab(CTabFolder folder, String name) {
        CTabItem tab = new CTabItem(folder, 0);
        if (name != null) {
            tab.setText(name);
            tab.setToolTipText(name);
        }
        return tab;
    }

    public static CTabFolder createTabFolder(Composite parent) {
        return WidgetFactory.createTabFolder(parent, 128);
    }

    public static CTabFolder createTabFolder(Composite parent, int style) {
        return WidgetFactory.createTabFolder(parent, style, 1808);
    }

    public static CTabFolder createTabFolder(Composite parent, int style, int gridStyle) {
        return WidgetFactory.createTabFolder(parent, style, gridStyle, 1);
    }

    public static CTabFolder createTabFolder(Composite parent, int style, int gridStyle, int span) {
        CTabFolder tabFolder = new CTabFolder(parent, style);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        tabFolder.setLayoutData((Object)gridData);
        if (WidgetUtil.hasStyle((Widget)tabFolder, 128)) {
            tabFolder.setSelectionBackground(TITLE_SELECTION_GRADIENT, TITLE_SELECTION_GRADIENT_PERCENTAGES);
            tabFolder.setSelectionForeground(TITLE_SELECTION_FOREGROUND);
        }
        return tabFolder;
    }

    public static TableColumn createTableColumn(Table table) {
        return WidgetFactory.createTableColumn(table, null);
    }

    public static TableColumn createTableColumn(Table table, String name) {
        TableColumn col = new TableColumn(table, 0);
        if (name != null) {
            col.setText(name);
        }
        return col;
    }

    public static void createTableColumns(Table table, String[] headers, int style) {
        String[] stringArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            TableColumn col = new TableColumn(table, style);
            col.setText(header);
            ++n2;
        }
    }

    public static TableViewer createTableViewer(Composite parent) {
        return WidgetFactory.createTableViewer(parent, 0);
    }

    public static TableViewer createTableViewer(Composite parent, int style) {
        if ((style & 0x40000000) == 0) {
            style |= 0xB00;
        }
        TableViewer viewer = new TableViewer(parent, style);
        Table table = viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        return viewer;
    }

    public static Text createTextBox(Composite parent) {
        return WidgetFactory.createTextBox(parent, 0, 1808);
    }

    public static Text createTextBox(Composite parent, int style, int gridStyle) {
        return WidgetFactory.createTextBox(parent, style, gridStyle, 1);
    }

    public static Text createTextBox(Composite parent, int style, int gridStyle, int span) {
        return WidgetFactory.createTextBox(parent, style, gridStyle, span, null);
    }

    public static Text createTextBox(Composite parent, int style, int gridStyle, int span, String text) {
        Text box = new Text(parent, style | 0x800 | 2 | 0x100 | 0x200);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        box.setLayoutData((Object)gridData);
        if (text != null) {
            box.setText(text);
        }
        return box;
    }

    public static StyledText createStyledTextBox(Composite parent, String text) {
        return WidgetFactory.createStyledTextBox(parent, 72, text);
    }

    public static StyledText createStyledTextBox(Composite parent, int style, String text) {
        return WidgetFactory.createStyledTextBox(parent, style, 768, text);
    }

    public static StyledText createStyledTextBox(Composite parent, int style, int gridStyle, String text) {
        return WidgetFactory.createStyledTextBox(parent, style, gridStyle, text, UiUtil.getSystemColor(22));
    }

    public static StyledText createStyledTextBox(Composite parent, int style, int gridStyle, String text, Color background) {
        StyledText box = new StyledText(parent, style);
        GridData gridData = new GridData(gridStyle);
        box.setLayoutData((Object)gridData);
        box.setBackground(background);
        if (text != null) {
            box.setText(text);
        }
        return box;
    }

    public static Text createTextField(Composite parent) {
        return WidgetFactory.createTextField(parent, 256);
    }

    public static Text createTextField(Composite parent, int gridStyle) {
        return WidgetFactory.createTextField(parent, gridStyle, 1);
    }

    public static Text createTextField(Composite parent, int gridStyle, int span) {
        return WidgetFactory.createTextField(parent, gridStyle, span, null);
    }

    public static IToolBarManager createViewFormToolBar(ViewForm theViewForm, int theStyle, int thePosition) {
        ToolBar tb = new ToolBar((Composite)theViewForm, theStyle);
        if (thePosition == 16384) {
            theViewForm.setTopLeft((Control)tb);
        } else if (thePosition == 0x1000000) {
            theViewForm.setTopCenter((Control)tb);
        } else {
            theViewForm.setTopRight((Control)tb);
        }
        return new ToolBarManager(tb);
    }

    public static IToolBarManager createViewFormToolBar(ViewForm theViewForm) {
        return WidgetFactory.createViewFormToolBar(theViewForm, 0x800040, 131072);
    }

    public static Text createTextField(Composite parent, int gridStyle, String text) {
        return WidgetFactory.createTextField(parent, gridStyle, 1, text);
    }

    public static Text createTextField(Composite parent, int gridStyle, int span, String text) {
        return WidgetFactory.createTextField(parent, gridStyle, span, text, 2048);
    }

    public static Text createTextField(Composite parent, int gridStyle, int span, String text, int style) {
        Text fld = new Text(parent, 0x800 | style);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        fld.setLayoutData((Object)gridData);
        if (text != null) {
            fld.setText(text);
        }
        return fld;
    }

    public static TreeViewer createTreeViewer(Composite parent, int style) {
        return WidgetFactory.createTreeViewer(parent, style, 1808);
    }

    public static TreeViewer createTreeViewer(Composite parent, int style, int gridStyle) {
        return WidgetFactory.createTreeViewer(parent, style, gridStyle, null);
    }

    public static TreeViewer createTreeViewer(Composite parent, int style, ITreeViewerController controller) {
        return WidgetFactory.createTreeViewer(parent, style, 1808, controller);
    }

    public static TreeViewer createTreeViewer(Composite theParent, int theStyle, int theGridStyle, ITreeViewerController theController) {
        TreeViewer viewer = WidgetFactory.createTreeViewer2(theParent, theStyle | 0x800, theController);
        viewer.getTree().setLayoutData((Object)new GridData(theGridStyle));
        return viewer;
    }

    public static TreeViewer createTreeViewer2(Composite parent, int style, ITreeViewerController controller) {
        CheckboxTreeViewer viewer = WidgetUtil.hasState(style |= 0x300, 32) ? new CheckboxTreeViewer(parent, style) : new TreeViewer(parent, style);
        final ITreeViewerController ctrlr = controller != null ? controller : new DefaultTreeViewerController();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ctrlr.itemSelected(event);
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener((TreeViewer)viewer, ctrlr){
            private final /* synthetic */ TreeViewer val$viewer;
            private final /* synthetic */ ITreeViewerController val$ctrlr;
            {
                this.val$viewer = treeViewer;
                this.val$ctrlr = iTreeViewerController;
            }

            public void doubleClick(DoubleClickEvent event) {
                Object node;
                this.val$viewer.setExpandedState(node, !this.val$viewer.getExpandedState(node = ((IStructuredSelection)event.getSelection()).getFirstElement()));
                this.val$ctrlr.itemDoubleClicked(event);
            }
        });
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                ctrlr.itemCollapsed(event);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ctrlr.itemExpanded(event);
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener((TreeViewer)viewer, ctrlr){
            private final /* synthetic */ TreeViewer val$viewer;
            private final /* synthetic */ ITreeViewerController val$ctrlr;
            {
                this.val$viewer = treeViewer;
                this.val$ctrlr = iTreeViewerController;
            }

            public void doubleClick(DoubleClickEvent event) {
                TreeItem item;
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && (obj = selection.getFirstElement()) != null && (item = WidgetUtil.findTreeItem(obj, this.val$viewer)) != null) {
                    this.val$ctrlr.update(item, false);
                }
            }
        });
        if (WidgetUtil.hasStyle((Widget)viewer.getTree(), 32)) {
            viewer.addCheckStateListener(new ICheckStateListener((TreeViewer)viewer, ctrlr){
                private final /* synthetic */ TreeViewer val$viewer;
                private final /* synthetic */ ITreeViewerController val$ctrlr;
                {
                    this.val$viewer = treeViewer;
                    this.val$ctrlr = iTreeViewerController;
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Object obj = event.getElement();
                    TreeItem item = WidgetUtil.findTreeItem(obj, this.val$viewer);
                    if (this.val$ctrlr.isItemCheckable(item)) {
                        WidgetUtil.setCheckedState(item, event.getChecked() ? 2 : 1, true, this.val$ctrlr);
                        this.val$ctrlr.checkedStateToggled(item);
                    } else {
                        this.val$ctrlr.update(item, false);
                    }
                    this.val$viewer.setSelection((ISelection)new StructuredSelection(item.getData()));
                }
            });
        }
        return viewer;
    }

    public static ViewForm createViewForm(Composite parent, int style, int gridStyle, int span) {
        ViewForm form = new ViewForm(parent, style);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        form.setLayoutData((Object)gridData);
        return form;
    }

    public static WizardDialog createWizardDialog(Shell shell, IWizard wizard) {
        CoreArgCheck.isNotNull((Object)shell);
        CoreArgCheck.isNotNull((Object)wizard);
        return new WizardDialog(shell, wizard){

            public void create() {
                this.setShellStyle(this.getShellStyle() | 0x10);
                super.create();
            }
        };
    }

    public static WrappingLabel createWrappingLabel(Composite parent, int gridStyle) {
        return WidgetFactory.createWrappingLabel(parent, gridStyle, 1);
    }

    public static WrappingLabel createWrappingLabel(Composite parent, int gridStyle, int span) {
        return WidgetFactory.createWrappingLabel(parent, gridStyle, span, null);
    }

    public static WrappingLabel createWrappingLabel(Composite parent, int gridStyle, String text) {
        return WidgetFactory.createWrappingLabel(parent, gridStyle, 1, text);
    }

    public static WrappingLabel createWrappingLabel(Composite parent, int gridStyle, int span, String text) {
        return new WrappingLabel(parent, gridStyle, span, text);
    }

    private WidgetFactory() {
    }
}

