/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.teiid.designer.ui.common.table.ColumnProvider;
import org.teiid.designer.ui.common.table.Table;
import org.teiid.designer.ui.common.table.TableProvider;
import org.teiid.designer.ui.common.widget.ButtonProvider;

public final class TableAndToolBar<T> {
    private final Table<T> table;
    private final ToolBarManager toolBarMgr;

    public <V> TableAndToolBar(Composite parent, int span, TableProvider<T> tableProvider, ColumnProvider<T, V> ... columnProviders) {
        this(parent, -1, span, tableProvider, columnProviders);
    }

    public <V> TableAndToolBar(Composite parent, int tableStyle, int span, final TableProvider<T> tableProvider, ColumnProvider<T, V> ... columnProviders) {
        this.table = tableStyle == -1 ? new Table<T>(parent, tableProvider, columnProviders) : new Table<T>(parent, tableStyle, tableProvider, columnProviders);
        ToolBar toolBar = new ToolBar(parent, 2056);
        this.toolBarMgr = new ToolBarManager(toolBar);
        if (tableProvider.isDoubleClickSupported()) {
            this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    tableProvider.doubleClicked(((IStructuredSelection)event.getSelection()).getFirstElement());
                }
            });
        }
    }

    public void add(final ButtonProvider buttonProvider) {
        assert (buttonProvider != null);
        if (this.toolBarMgr.getItems().length != 0) {
            this.toolBarMgr.add((IContributionItem)new Separator());
        }
        Action action = new Action(buttonProvider.getText(), 2048){

            public void run() {
                buttonProvider.selected((IStructuredSelection)TableAndToolBar.this.getViewer().getSelection());
                TableAndToolBar.this.getViewer().refresh();
            }
        };
        action.setToolTipText(buttonProvider.getToolTip());
        action.setImageDescriptor(buttonProvider.getImageDescriptor());
        this.toolBarMgr.add((IAction)action);
        if (!buttonProvider.isEnabled((IStructuredSelection)this.getViewer().getSelection())) {
            action.setEnabled(false);
        }
        this.toolBarMgr.update(true);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = buttonProvider.isEnabled((IStructuredSelection)event.getSelection());
                if (enabled != this.val$action.isEnabled()) {
                    this.val$action.setEnabled(enabled);
                }
            }
        });
    }

    public Table<T> getTable() {
        return this.table;
    }

    public TableViewer getViewer() {
        return this.table.getViewer();
    }

    public void setInput(Object input) {
        this.table.setInput(input);
    }
}

