/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.designer.ui.common.table.ResourceEditingSupport;

public abstract class PropertyEditingSupport
extends ResourceEditingSupport {
    public PropertyEditingSupport(ColumnViewer viewer, IResource resource) {
        super(viewer, resource);
    }

    @Override
    protected boolean canEdit(Object element) {
        PropertyDefinition propDefn = this.getPropertyDefinition(element);
        return super.canEdit(element) && propDefn.isModifiable();
    }

    @Override
    protected CellEditor getCellEditor(Object element) {
        PropertyDefinition propDefn = this.getPropertyDefinition(element);
        if (!propDefn.isModifiable()) {
            return null;
        }
        if (propDefn.isMasked()) {
            this.currentEditor = new TextCellEditor((Composite)this.getViewer().getControl());
            ((Text)this.currentEditor.getControl()).setEchoChar('*');
            return this.currentEditor;
        }
        return super.getCellEditor(element);
    }

    protected PropertyDefinition getPropertyDefinition(Object element) {
        return (PropertyDefinition)element;
    }

    @Override
    protected String[] refreshItems(Object element) {
        PropertyDefinition propDefn = this.getPropertyDefinition(element);
        return propDefn.getAllowedValues();
    }
}

