/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.dialog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;

public class FileContentsDialog
extends Dialog {
    private StyledTextEditor textEditor;
    private String fileText;
    private String fileName;

    public FileContentsDialog(Shell shell, String title, File file, String displayedFileName) {
        super(shell, title);
        this.fileName = file.getName();
        this.loadText(file);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgPanel = (Composite)super.createDialogArea(parent);
        Group descGroup = WidgetFactory.createGroup(dlgPanel, "Contents", 0);
        descGroup.setLayoutData((Object)new GridData(1808));
        Composite innerPanel = new Composite((Composite)descGroup, 0);
        innerPanel.setLayout((Layout)new GridLayout());
        GridData pgd = new GridData(1808);
        pgd.minimumWidth = 400;
        pgd.minimumHeight = 400;
        pgd.grabExcessVerticalSpace = true;
        pgd.grabExcessHorizontalSpace = true;
        innerPanel.setLayoutData((Object)pgd);
        this.textEditor = new StyledTextEditor(innerPanel, 2562);
        GridData gdt = new GridData(1808);
        gdt.widthHint = 400;
        gdt.heightHint = 400;
        this.textEditor.setLayoutData(gdt);
        this.textEditor.setEditable(false);
        this.textEditor.setAllowFind(false);
        this.textEditor.getTextWidget().setWordWrap(true);
        this.textEditor.setText(this.fileText);
        return dlgPanel;
    }

    protected Control createContents(Composite parent) {
        Control superControl = super.createContents(parent);
        this.getButton(0).setEnabled(true);
        return superControl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadText(File file) {
        FileInputStream fin = null;
        try {
            try {
                int ch;
                StringBuffer strContent = new StringBuffer("");
                fin = new FileInputStream(file);
                while ((ch = fin.read()) != -1) {
                    strContent.append((char)ch);
                }
                this.fileText = strContent.toString();
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (fin == null) return;
                try {
                    fin.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fin == null) return;
                try {
                    fin.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

