/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.label;

import java.util.List;
import org.fusesource.ide.commons.ui.label.Bar;
import org.fusesource.ide.commons.ui.label.BarColour;

public class Health {
    private String text;
    private Double current;
    private Double minimum;
    private Double maximum;

    public Health() {
    }

    public static Health newInstance(String text, Number current, Number minimum, Number maximum) {
        return new Health(text, Health.toDouble(current), Health.toDouble(minimum), Health.toDouble(maximum));
    }

    protected static Double toDouble(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            return (Double)n;
        }
        return n.doubleValue();
    }

    public Health(String text, Double current, Double minimum, Double maximum) {
        this.text = text;
        this.current = current;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public void addBars(List<Bar> bars) {
        if (this.current == null) {
            return;
        }
        Double[] doubleArray = new Double[]{this.current, this.minimum, this.maximum};
        double scale = this.max(doubleArray);
        if (scale > 0.0) {
            if (this.minimum == null || this.minimum <= 0.0 || this.equal(this.current, this.minimum)) {
                bars.add(new Bar(BarColour.Green, this.current / scale));
            } else if (this.current > this.minimum) {
                bars.add(new Bar(BarColour.Green, this.minimum / scale));
                BarColour overMin = BarColour.Green;
                BarColour overMax = BarColour.DarkGreen;
                if (this.maximum != null && this.current > this.maximum) {
                    bars.add(new Bar(overMin, (this.maximum - this.minimum) / scale));
                    bars.add(new Bar(overMax, (this.current - this.maximum) / scale));
                } else {
                    bars.add(new Bar(overMin, (this.current - this.minimum) / scale));
                }
            } else if (this.current / scale > 0.1) {
                bars.add(new Bar(BarColour.Yellow, this.current / scale));
            } else {
                bars.add(new Bar(BarColour.Red, 1.0));
            }
        }
        if (this.text != null && !bars.isEmpty()) {
            Bar bar = bars.get(0);
            bar.setText(this.text);
        }
    }

    private boolean equal(double d1, double d2) {
        double diff = Math.abs(d1 - d2);
        return diff < 1.0E-4;
    }

    private double max(Double ... numbers) {
        double answer = Double.MIN_VALUE;
        Double[] doubleArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            double value;
            Double d = doubleArray[n2];
            if (d != null && (value = d.doubleValue()) > answer) {
                answer = value;
            }
            ++n2;
        }
        return answer;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Double getCurrent() {
        return this.current;
    }

    public void setCurrent(Double current) {
        this.current = current;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }
}

