/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.config;

import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.PreferencesHelper;
import org.fusesource.ide.commons.util.BeanSupport;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class ConfigurationDetails
extends BeanSupport {
    private String id;

    public ConfigurationDetails() {
    }

    public ConfigurationDetails(String id) {
        this.id = id;
    }

    protected abstract void store(Preferences var1);

    public Preferences getConfigurationNode() {
        return PreferencesHelper.configurationNode(this.getConfigurationNodeId());
    }

    protected String getConfigurationNodeId() {
        return this.getClass().getName();
    }

    public void flush() {
        try {
            Preferences node = this.getConfigurationNode();
            if (this.id == null) {
                int i = node.childrenNames().length;
                do {
                    this.id = String.valueOf(this.getIdPrefix()) + ++i;
                } while (node.nodeExists(this.id));
            }
            Preferences chlld = node.node(this.id);
            this.store(chlld);
            PreferencesHelper.flush(node);
        }
        catch (BackingStoreException e) {
            Activator.showUserError("Failed to store configuration: " + this, e.getMessage(), (Exception)((Object)e));
        }
    }

    public void delete() {
        try {
            Preferences node = this.getConfigurationNode();
            if (this.id != null) {
                Preferences child = node.node(this.id);
                child.removeNode();
            }
            PreferencesHelper.flush(node);
        }
        catch (BackingStoreException e) {
            Activator.showUserError("Failed to remove + " + this + " from configuration store", e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String getIdPrefix() {
        return "n";
    }

    public String getId() {
        return this.id;
    }
}

