/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.fusesource.ide.commons.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class Bundles {
    public static void startBundle(BundleContext context, String containsName) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String name = bundle.getSymbolicName();
            if (name.contains(containsName)) {
                Activator.getLogger().debug("About to start bundle: " + name);
                try {
                    bundle.start();
                }
                catch (Exception e) {
                    Activator.getLogger().error("Failed to start: " + e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    public static void stopBundle(BundleContext context, String containsName) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String name = bundle.getSymbolicName();
            if (name.contains(containsName)) {
                Activator.getLogger().debug("About to start bundle: " + name);
                try {
                    bundle.stop();
                }
                catch (Exception e) {
                    Activator.getLogger().error("Failed to start: " + e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    public static <T> T lookupService(BundleContext context, Class<T> aClass) {
        return Bundles.lookupService(context, aClass.getName(), aClass);
    }

    public static <T> T lookupService(BundleContext context, String name, Class<T> aClass) {
        ServiceReference ref = context.getServiceReference(name);
        return Bundles.getServiceFromRef(context, name, aClass, ref);
    }

    public static <T> List<T> lookupServices(BundleContext context, Class<T> aClass) throws InvalidSyntaxException {
        return Bundles.lookupServices(context, aClass.getName(), aClass);
    }

    public static <T> List<T> lookupServices(BundleContext context, String name, Class<T> aClass) throws InvalidSyntaxException {
        String filter = null;
        ServiceReference[] refs = context.getServiceReferences(name, filter);
        ArrayList<T> answer = new ArrayList<T>();
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T service = Bundles.getServiceFromRef(context, name, aClass, ref);
                if (service != null) {
                    answer.add(service);
                }
                ++n2;
            }
        }
        return answer;
    }

    public static <T> Map<T, Map<String, Object>> lookupServicesMap(BundleContext context, Class<T> aClass) throws InvalidSyntaxException {
        return Bundles.lookupServicesMap(context, aClass.getName(), aClass);
    }

    public static <T> Map<T, Map<String, Object>> lookupServicesMap(BundleContext context, String name, Class<T> aClass) throws InvalidSyntaxException {
        String filter = null;
        ServiceReference[] refs = context.getServiceReferences(name, filter);
        HashMap<T, Map<String, Object>> answer = new HashMap<T, Map<String, Object>>();
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T service = Bundles.getServiceFromRef(context, name, aClass, ref);
                if (service != null) {
                    Map<String, Object> properties = Bundles.getPropertiesMap(ref);
                    answer.put(service, properties);
                }
                ++n2;
            }
        }
        return answer;
    }

    public static Properties getProperties(ServiceReference<?> ref) {
        String[] keys;
        Properties properties = new Properties();
        String[] stringArray = keys = ref.getPropertyKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, ref.getProperty(key));
            ++n2;
        }
        return properties;
    }

    public static Map<String, Object> getPropertiesMap(ServiceReference<?> ref) {
        String[] keys;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] stringArray = keys = ref.getPropertyKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, ref.getProperty(key));
            ++n2;
        }
        return properties;
    }

    protected static <T> T getServiceFromRef(BundleContext context, String name, Class<T> aClass, ServiceReference<?> ref) {
        if (ref == null) {
            Activator.getLogger().debug("No service for " + name);
        } else {
            Object value = context.getService(ref);
            if (aClass.isInstance(value)) {
                return aClass.cast(value);
            }
            Activator.getLogger().warning("Service for " + name + " is not an instanceof " + aClass.getCanonicalName() + " but was: " + value);
        }
        return null;
    }
}

