/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.validators;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.IDiagramProfile;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.Messages;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.ServletUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;

public class CallActivityValidator
extends AbstractBpmn2ElementValidator<CallActivity> {
    private IDiagramProfile profile;
    private String uuid = "uuid";

    public CallActivityValidator(IValidationContext ctx) {
        super(ctx);
    }

    public IStatus validate(CallActivity object) {
        if (object.getCalledElementRef() != null) {
            String[] packageAssetInfo = ServletUtil.findPackageAndAssetInfo(this.uuid, this.profile);
            String packageName = packageAssetInfo[0];
            List<String> allProcessesInPackage = ServletUtil.getAllProcessesInPackage(packageName, this.profile);
            boolean foundCalledElementProcess = false;
            for (String p : allProcessesInPackage) {
                String processContent = ServletUtil.getProcessSourceContent(packageName, p, this.profile);
                Pattern pattern = Pattern.compile("<\\S*process[\\s\\S]*id=\"" + object.getCalledElementRef() + "\"", 8);
                Matcher m = pattern.matcher(processContent);
                if (!m.find()) continue;
                foundCalledElementProcess = true;
                break;
            }
            foundCalledElementProcess = true;
            if (!foundCalledElementProcess) {
                this.addStatus((EObject)object, 4, Messages.CallActivityConstraint_No_Process, new Object[]{object.getCalledElementRef()});
            }
        }
        EStructuralFeature feature = ModelDecorator.getAnyAttribute((EObject)object, (String)"independent");
        Boolean independent = (Boolean)object.eGet(feature);
        feature = ModelDecorator.getAnyAttribute((EObject)object, (String)"waitForCompletion");
        Boolean waitForCompletion = (Boolean)object.eGet(feature);
        if (!independent.booleanValue() && !waitForCompletion.booleanValue()) {
            this.addStatus((EObject)object, 4, Messages.CallActivityConstraint_Independent_And_WaitForCompletion_False, new Object[0]);
        }
        return this.getResult();
    }
}

