/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.wizards;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.db.generic.ui.wizard.NewJDBCFilteredCPWizard;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.datatools.JdbcTranslatorHelper;
import org.teiid.designer.datatools.ui.actions.EditConnectionProfileAction;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcManager;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.relational.JdbcImporter;
import org.teiid.designer.jdbc.relational.util.JdbcModelProcessorManager;
import org.teiid.designer.jdbc.ui.InternalModelerJdbcUiPluginConstants;
import org.teiid.designer.jdbc.ui.util.JdbcUiUtil;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class JdbcSourceSelectionPage
extends AbstractWizardPage
implements IChangeNotifier,
InternalModelerJdbcUiPluginConstants,
InternalModelerJdbcUiPluginConstants.Widgets,
InternalUiConstants.Widgets,
CoreStringUtil.Constants {
    private static final String CP_FILTER_SETTINGS = "org.eclipse.datatools.connectivity.sqm.filterSettings";
    private static final String SCHEMA_FILTER = "DatatoolsSchemaFilterPredicate";
    private static final String TABLE_FILTER = "DatatoolsTableFilterPredicate";
    private static final String STORED_PROC_FILTER = "DatatoolsSPFilterPredicate";
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcSourceSelectionPage.class);
    private static final String TITLE = JdbcSourceSelectionPage.getString("title");
    private static final String TITLE_WITH_VDB_SOURCE = String.valueOf(TITLE) + " (VDB source model)";
    private static final String INITIAL_MESSAGE = JdbcSourceSelectionPage.getString("initialMessage");
    private static final int PROFILE_COLUMN_COUNT = 3;
    private static final int EDIT_PANEL_COLUMN_COUNT = 2;
    private static final String SOURCE_LABEL = JdbcSourceSelectionPage.getString("sourceLabel");
    private static final String NEW_BUTTON = Util.getString("Widgets.newLabel", new Object[0]);
    private static final String EDIT_BUTTON = Util.getString("Widgets.editLabel", new Object[0]);
    private static final String INVALID_PAGE_MESSAGE = JdbcSourceSelectionPage.getString("invalidPageMessage");
    private static final String TEIID_PROFILE_OPTIONS_GROUP_LABEL = JdbcSourceSelectionPage.getString("teiidProfileOptionsGroupLabel");
    private static final String IS_VDB_SOURCE_MODEL_CHECKBOX = JdbcSourceSelectionPage.getString("isVdbSourceModelCheckboxLabel");
    private static final String IS_VDB_SOURCE_MODEL_CHECKBOX_MESSAGE = JdbcSourceSelectionPage.getString("isVdbSourceModelCheckboxLabel.message");
    JdbcManager mgr;
    private JdbcSource src;
    private Connection connection;
    private ListenerList notifier;
    private String password;
    private String metadataProcessor;
    private ILabelProvider srcLabelProvider;
    private Combo srcCombo;
    private Button editCPButton;
    private Button isVdbSourceModelCheckBox;
    private Composite editPanel;
    private Composite teiidProfileGroup;
    private CLabel driverLabel;
    private CLabel urlLabel;
    private CLabel userNameLabel;
    private Text pwdText;
    private Map enableMap;
    private Composite processorPanel;
    private ILabelProvider processorLabelProvider;
    private Combo processorCombo;
    private IConnectionProfile connectionProfile;
    private boolean isTeiidConnection;
    private boolean isVdbSourceModel = false;
    private String initialProfileName;
    private JdbcImporter importer;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public JdbcSourceSelectionPage() {
        this(null);
    }

    public JdbcSourceSelectionPage(JdbcSource source) {
        super(JdbcSourceSelectionPage.class.getSimpleName(), TITLE);
        this.src = source;
        this.mgr = JdbcUiUtil.getJdbcManager();
        this.notifier = new ListenerList(1);
        this.setPageComplete(false);
    }

    public void addChangeListener(IChangeListener listener) {
        this.notifier.add((Object)listener);
    }

    public boolean connect() {
        if (this.connection == null) {
            this.connection = JdbcUiUtil.connect(this.getSource(), this.getPassword());
            if (this.connection == null) {
                return false;
            }
            this.fireStateChanged();
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayoutData((Object)new GridData(768));
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, false);
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(768));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Group profileGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)SOURCE_LABEL, (int)0, (int)2, (int)3);
        profileGroup.setLayoutData((Object)new GridData(768));
        ArrayList sourceList = new ArrayList(this.mgr.getJdbcSources().size());
        for (Object source : this.mgr.getJdbcSources()) {
            if (source == null || sourceList.contains(source)) continue;
            sourceList.add(source);
        }
        this.srcLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((JdbcSource)source).getName();
            }
        };
        this.srcCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, sourceList, (Object)this.src, (ILabelProvider)this.srcLabelProvider, (boolean)true);
        this.srcCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcSourceSelectionPage.this.sourceModified();
            }
        });
        this.srcCombo.setVisibleItemCount(10);
        WidgetFactory.createButton((Composite)profileGroup, (String)NEW_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcSourceSelectionPage.this.launchSourceWizard();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)EDIT_BUTTON);
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcSourceSelectionPage.this.editConnectionProfile();
            }
        });
        Group processorPanel = WidgetFactory.createGroup((Composite)mainPanel, (String)JdbcSourceSelectionPage.getString("processorCombo"), (int)0, (int)1);
        processorPanel.setLayoutData((Object)new GridData(768));
        Collection processors = JdbcModelProcessorManager.getMetadataProcessorNames();
        ArrayList processorList = new ArrayList(processors.size());
        for (Object source : processors) {
            if (source == null || processorList.contains(source)) continue;
            processorList.add(source);
        }
        this.processorLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return (String)source;
            }
        };
        this.processorCombo = WidgetFactory.createCombo((Composite)processorPanel, (int)8, (int)768, processorList, (Object)this.metadataProcessor, (ILabelProvider)this.processorLabelProvider, (boolean)true);
        this.processorCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcSourceSelectionPage.this.processorModified();
            }
        });
        this.processorCombo.setVisibleItemCount(10);
        this.processorCombo.setToolTipText(JdbcSourceSelectionPage.getString("processorComboTooltip"));
        this.editPanel = WidgetFactory.createGroup((Composite)mainPanel, (String)JdbcSourceSelectionPage.getString("propertiesLabel"), (int)256, (int)1, (int)2);
        WidgetFactory.createLabel((Composite)this.editPanel, (String)DRIVER_LABEL);
        this.driverLabel = WidgetFactory.createLabel((Composite)this.editPanel, (int)768);
        WidgetFactory.createLabel((Composite)this.editPanel, (String)URL_LABEL);
        this.urlLabel = WidgetFactory.createLabel((Composite)this.editPanel, (int)768);
        WidgetFactory.createLabel((Composite)this.editPanel, (String)USER_NAME_LABEL);
        this.userNameLabel = WidgetFactory.createLabel((Composite)this.editPanel, (int)768);
        WidgetFactory.createLabel((Composite)this.editPanel, (String)PASSWORD_LABEL);
        this.pwdText = WidgetFactory.createTextField((Composite)this.editPanel, (int)768);
        this.pwdText.setEchoChar('*');
        this.pwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcSourceSelectionPage.this.passwordModified();
            }
        });
        this.teiidProfileGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)TEIID_PROFILE_OPTIONS_GROUP_LABEL, (int)256, (int)1, (int)1);
        this.isVdbSourceModelCheckBox = WidgetFactory.createCheckBox((Composite)this.teiidProfileGroup, (String)IS_VDB_SOURCE_MODEL_CHECKBOX, (int)0, (int)1);
        this.isVdbSourceModelCheckBox.setToolTipText(JdbcSourceSelectionPage.getString("isVdbSourceModelCheckboxTooltip"));
        this.isVdbSourceModelCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcSourceSelectionPage.this.isVdbSourceModelCheckBoxSelected();
            }
        });
        Text descriptionText = new Text(this.teiidProfileGroup, 72);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 60;
        gd.widthHint = 500;
        descriptionText.setLayoutData((Object)gd);
        descriptionText.setText(IS_VDB_SOURCE_MODEL_CHECKBOX_MESSAGE);
        descriptionText.setBackground(this.teiidProfileGroup.getBackground());
        descriptionText.setForeground(Display.getCurrent().getSystemColor(10));
        this.sourceModified();
        if (this.initialProfileName != null) {
            this.selectConnectionProfile(this.initialProfileName);
        }
        if (this.validatePage()) {
            this.setMessage(INITIAL_MESSAGE);
        }
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.updateWidgetsState();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public IWizardPage getNextPage() {
        if (!this.connect()) {
            return null;
        }
        return super.getNextPage();
    }

    public String getPassword() {
        return this.password;
    }

    public JdbcSource getSource() {
        return this.src;
    }

    public String getMetadataProcessor() {
        return this.metadataProcessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void launchSourceWizard() {
        NewJDBCFilteredCPWizard wiz = new NewJDBCFilteredCPWizard();
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
        wizardDialog.setBlockOnOpen(true);
        CPListener listener = new CPListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        if (wizardDialog.open() == 0) {
            try {
                try {
                    JdbcSource theNewJdbcSource = this.src = listener.getJdbcSource();
                    this.mgr.reload(null);
                    WidgetUtil.setComboItems((Combo)this.srcCombo, (Collection)this.mgr.getJdbcSources(), (ILabelProvider)this.srcLabelProvider, (boolean)true);
                    if (theNewJdbcSource == null) return;
                    WidgetUtil.setComboText((Combo)this.srcCombo, (Object)theNewJdbcSource, (ILabelProvider)this.srcLabelProvider);
                    return;
                }
                catch (JdbcException e) {
                    e.printStackTrace();
                    this.sourceModified();
                    ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
                }
                return;
            }
            finally {
                this.sourceModified();
                ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
            }
        } else {
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        }
    }

    void editConnectionProfile() {
        if (this.connectionProfile != null) {
            IConnectionProfile currentProfile = this.connectionProfile;
            EditConnectionProfileAction action = new EditConnectionProfileAction(this.getShell(), currentProfile);
            CPListener listener = new CPListener();
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            action.run();
            if (action.wasFinished()) {
                block8: {
                    try {
                        try {
                            this.src = listener.getJdbcSource();
                            this.mgr.reload(null);
                            WidgetUtil.setComboItems((Combo)this.srcCombo, (Collection)this.mgr.getJdbcSources(), (ILabelProvider)this.srcLabelProvider, (boolean)true);
                            WidgetUtil.setComboText((Combo)this.srcCombo, (Object)this.src, (ILabelProvider)this.srcLabelProvider);
                            this.selectConnectionProfile(currentProfile.getName());
                        }
                        catch (JdbcException e) {
                            e.printStackTrace();
                            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
                        throw throwable;
                    }
                    ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
                }
                this.sourceModified();
            } else {
                ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
            }
        }
    }

    void passwordModified() {
        this.password = this.pwdText.getText();
        this.connection = null;
        this.validatePage();
    }

    public void removeChangeListener(IChangeListener listener) {
        this.notifier.remove((Object)listener);
    }

    public void selectConnectionProfile(String name) {
        if (name == null) {
            return;
        }
        this.initialProfileName = name;
        int cpIndex = -1;
        int i = 0;
        if (this.srcCombo != null && !this.srcCombo.isDisposed()) {
            String[] stringArray = this.srcCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                    cpIndex = i;
                    break;
                }
                ++i;
                ++n2;
            }
            if (cpIndex > -1) {
                this.srcCombo.select(cpIndex);
            }
        }
        this.updateWidgetsState();
    }

    void sourceModified() {
        String text = this.srcCombo.getText();
        if (text.length() > 0) {
            if (this.enableMap != null) {
                WidgetUtil.restore((Map)this.enableMap);
                this.enableMap = null;
            }
            this.src = this.mgr.findSources(text)[0];
            this.driverLabel.setText(this.src.getDriverName());
            this.urlLabel.setText(this.src.getUrl());
            JdbcUiUtil.setText(this.userNameLabel, this.src.getUsername());
            if (this.src.getPassword() != null) {
                JdbcUiUtil.setText(this.pwdText, this.src.getPassword());
            }
            this.connectionProfile = this.mgr.getConnectionProfile(text);
        } else {
            this.src = null;
            this.driverLabel.setText("");
            this.urlLabel.setText("");
            this.userNameLabel.setText("");
            if (this.enableMap == null) {
                this.enableMap = WidgetUtil.disable((Composite)this.editPanel);
            }
            this.connectionProfile = null;
        }
        this.connection = null;
        if (this.connectionProfile != null) {
            String item;
            String translator = JdbcTranslatorHelper.getModelProcessorType((IConnectionProfile)this.connectionProfile);
            String processorType = JdbcModelProcessorManager.getProcessorNameWithType((String)translator);
            String[] items = this.processorCombo.getItems();
            int index = -1;
            int matchIndex = -1;
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                item = stringArray[n2];
                ++index;
                if (item.equalsIgnoreCase(processorType)) {
                    matchIndex = index;
                    break;
                }
                ++n2;
            }
            if (matchIndex > -1) {
                this.processorCombo.select(matchIndex);
                this.processorModified();
            } else {
                matchIndex = -1;
                index = -1;
                stringArray = items;
                n = items.length;
                n2 = 0;
                while (n2 < n) {
                    item = stringArray[n2];
                    ++index;
                    if (item.equalsIgnoreCase("JDBC (default)")) {
                        matchIndex = index;
                        break;
                    }
                    ++n2;
                }
                this.processorCombo.select(matchIndex);
                this.processorModified();
            }
            Properties props = this.connectionProfile.getProperties(CP_FILTER_SETTINGS);
            if (props != null) {
                String schemaFilterStr = (String)props.get(SCHEMA_FILTER);
                String tableFilterStr = (String)props.get(TABLE_FILTER);
                String storedProcFilterStr = (String)props.get(STORED_PROC_FILTER);
                if (!CoreStringUtil.isEmpty((String)schemaFilterStr)) {
                    this.importer.setSchemaFilter(schemaFilterStr);
                }
                if (!CoreStringUtil.isEmpty((String)tableFilterStr)) {
                    this.importer.setTableFilter(tableFilterStr);
                }
                if (!CoreStringUtil.isEmpty((String)storedProcFilterStr)) {
                    this.importer.setStoredProcFilter(storedProcFilterStr);
                }
            }
        }
        this.validatePage();
        this.editCPButton.setEnabled(this.connectionProfile != null);
        if (this.connectionProfile != null) {
            Properties props = this.connectionProfile.getBaseProperties();
            String vendor = props.getProperty("org.eclipse.datatools.connectivity.db.vendor");
            this.isTeiidConnection = vendor != null && vendor.equalsIgnoreCase("TEIID");
        }
        this.updateWidgetsState();
    }

    void processorModified() {
        String text = this.processorCombo.getText();
        if (text.length() > 0) {
            if (this.enableMap != null) {
                WidgetUtil.restore((Map)this.enableMap);
                this.enableMap = null;
            }
            this.metadataProcessor = JdbcModelProcessorManager.getProcessorTypeWithName((String)text);
        } else if (this.enableMap == null) {
            this.enableMap = WidgetUtil.disable((Composite)this.processorPanel);
        }
        this.validatePage();
    }

    void isVdbSourceModelCheckBoxSelected() {
        this.isVdbSourceModel = this.isVdbSourceModelCheckBox.getSelection();
        this.importer.setIsVdbSourceModel(this.isVdbSourceModel);
    }

    void updateWidgetsState() {
        if (this.getControl() == null) {
            return;
        }
        this.teiidProfileGroup.setVisible(this.isTeiidConnection());
        boolean doSetSelected = !this.isVdbSourceModelCheckBox.isVisible();
        this.isVdbSourceModelCheckBox.setVisible(this.isTeiidConnection());
        if (doSetSelected) {
            this.isVdbSourceModelCheckBox.setSelection(true);
        }
        if (!this.isTeiidConnection) {
            this.isVdbSourceModelCheckBox.setSelection(false);
        }
        this.isVdbSourceModelCheckBoxSelected();
        if (this.importer.isVdbSourceModel()) {
            this.setTitle(TITLE_WITH_VDB_SOURCE);
        } else {
            this.setTitle(TITLE);
        }
    }

    private boolean validatePage() {
        this.isVdbSourceModelCheckBox.setVisible(this.isTeiidConnection);
        this.isVdbSourceModelCheckBox.setSelection(this.isTeiidConnection);
        Collection openModelProjects = DotProjectUtils.getOpenModelProjects();
        if (openModelProjects.size() == 0) {
            WizardUtil.setPageComplete((WizardPage)this, (String)JdbcSourceSelectionPage.getString("noOpenProjectsMessage"), (int)3);
        } else if (this.srcCombo.getText().length() == 0) {
            WizardUtil.setPageComplete((WizardPage)this, (String)INVALID_PAGE_MESSAGE, (int)3);
        } else if (this.password == null) {
            WizardUtil.setPageComplete((WizardPage)this, (String)JdbcSourceSelectionPage.getString("noPasswordMessage"), (int)3);
        } else {
            WizardUtil.setPageComplete((WizardPage)this);
        }
        this.fireStateChanged();
        return openModelProjects.size() > 0;
    }

    void fireStateChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.notifier.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IChangeListener)listener).stateChanged((IChangeNotifier)this);
            ++n2;
        }
    }

    public boolean isTeiidConnection() {
        return this.isTeiidConnection;
    }

    public String getVdbName() {
        int atIndex;
        String vdbName;
        Properties props;
        String teiidURL;
        if (this.connectionProfile != null && (teiidURL = (props = this.connectionProfile.getBaseProperties()).getProperty("org.eclipse.datatools.connectivity.db.URL")) != null && teiidURL.startsWith("jdbc:teiid") && (vdbName = teiidURL.substring(11, atIndex = teiidURL.indexOf(64))) != null) {
            return vdbName;
        }
        return null;
    }

    public void setImporter(JdbcImporter importer) {
        this.importer = importer;
    }

    public class CPListener
    implements IProfileListener {
        IConnectionProfile latestProfile;

        public void profileAdded(IConnectionProfile profile) {
            this.latestProfile = profile;
            JdbcSourceSelectionPage.this.fireStateChanged();
        }

        public void profileChanged(IConnectionProfile profile) {
            this.latestProfile = profile;
        }

        public void profileDeleted(IConnectionProfile profile) {
        }

        public JdbcSource getJdbcSource() {
            if (this.latestProfile != null) {
                return JdbcSourceSelectionPage.this.mgr.getJdbcSource(this.latestProfile);
            }
            return null;
        }
    }
}

