/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcManager;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.relational.util.JdbcRelationalUtil;
import org.teiid.designer.jdbc.ui.InternalModelerJdbcUiPluginConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetUtil;

public final class JdbcUiUtil
implements InternalModelerJdbcUiPluginConstants,
InternalModelerJdbcUiPluginConstants.Widgets,
InternalUiConstants.Widgets,
CoreStringUtil.Constants {
    static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcUiUtil.class);
    private static final String CONNECTION_FAILED_MESSAGE = JdbcUiUtil.getString("connectionFailedMessage");
    private static final String ERROR_ACCESSING_DATABASE_MESSAGE = JdbcUiUtil.getString("errorAccessingDatabaseMessage");
    private static final String ERROR_RELOADING_MESSAGE = JdbcUiUtil.getString("errorReloadingMessage");
    private static final String ERROR_SAVING_CHANGES_MESSAGE = JdbcUiUtil.getString("errorSavingChangesMessage");
    private static final String ERROR_STARTING_MANAGER_MESSAGE = JdbcUiUtil.getString("errorStartingManagerMessage");
    private static final String NONE_SPECIFIED_MESSAGE = JdbcUiUtil.getString("noneSpecifiedMessage");
    static final String SAVING_CHANGES_MESSAGE = JdbcUiUtil.getString("savingChangesMessage");
    static transient Connection connection;

    public static JdbcManager getJdbcManager() {
        try {
            return JdbcRelationalUtil.getJdbcManager();
        }
        catch (Exception err) {
            JdbcUiUtil.showError(err, ERROR_STARTING_MANAGER_MESSAGE);
            return null;
        }
    }

    public static synchronized Connection connect(final JdbcSource database, final String password) {
        connection = null;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                Object[] params = new Object[]{""};
                if (database.getUrl() != null && database.getUrl().trim().length() != 0) {
                    params[0] = database.getUrl();
                }
                String taskName = Util.getString(String.valueOf(I18N_PREFIX) + "connectingMessage", params);
                monitor.setTaskName(taskName);
                try {
                    try {
                        connection = JdbcUiUtil.getJdbcManager().createConnection(database, password, monitor);
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            JdbcUiUtil.showErrorCause(err, CONNECTION_FAILED_MESSAGE);
        }
        return connection;
    }

    public static void reload() {
        try {
            JdbcUiUtil.getJdbcManager().reload(null);
        }
        catch (JdbcException err) {
            JdbcUiUtil.showError(err, ERROR_RELOADING_MESSAGE);
        }
    }

    public static boolean saveChanges() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.setTaskName(SAVING_CHANGES_MESSAGE);
                try {
                    try {
                        JdbcUiUtil.getJdbcManager().saveChanges(monitor);
                    }
                    catch (IOException err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(false, false, op);
            return true;
        }
        catch (Exception err) {
            JdbcUiUtil.showError(err, ERROR_SAVING_CHANGES_MESSAGE);
            return false;
        }
    }

    public static void setEnabled(Control control, boolean enable) {
        control.setEnabled(enable);
        Control[] ctrls = control.getParent().getChildren();
        int ndx = ctrls.length;
        while (--ndx >= 0) {
            if (ctrls[ndx] != control) continue;
            ctrls[ndx - 1].setEnabled(enable);
            break;
        }
    }

    public static void setText(CLabel label, String text) {
        if (text == null && label.isEnabled()) {
            JdbcUiUtil.setEnabled((Control)label, false);
            label.setText(NONE_SPECIFIED_MESSAGE);
        } else {
            if (text != null && !label.isEnabled()) {
                JdbcUiUtil.setEnabled((Control)label, true);
            }
            label.setText(text);
        }
    }

    public static void setText(Text textFld, String text) {
        if (text == null && textFld.isEnabled()) {
            JdbcUiUtil.setEnabled((Control)textFld, false);
            textFld.setText("");
        } else {
            if (text != null && !textFld.isEnabled()) {
                JdbcUiUtil.setEnabled((Control)textFld, true);
            }
            textFld.setText(text);
        }
    }

    public static void setText(Combo combo, String text) {
        if (text == null && combo.isEnabled()) {
            JdbcUiUtil.setEnabled((Control)combo, false);
            combo.setText("");
        } else {
            if (text != null && !combo.isEnabled()) {
                JdbcUiUtil.setEnabled((Control)combo, true);
            }
            combo.setText(text);
        }
    }

    public static void showAccessError(Throwable error) {
        JdbcUiUtil.showErrorCause(error, ERROR_ACCESSING_DATABASE_MESSAGE);
    }

    public static void showError(Throwable error, String message) {
        Util.log(error);
        WidgetUtil.showError((String)message);
    }

    public static void showErrorCause(Throwable error, String message) {
        Util.log(error);
        WidgetUtil.showCause((String)message, (Throwable)error);
    }

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private JdbcUiUtil() {
    }
}

