/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xmi;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xmi.ModelImportInfo;

public final class XMIHeader {
    private List<String> namespaceURIs = new ArrayList<String>();
    private List<ModelImportInfo> modelImportInfos = new ArrayList<ModelImportInfo>();
    private String primaryMetamodelURI;
    private String uuid;
    private String description;
    private String modelType;
    private String modelNamespaceUri;
    private boolean visible = true;
    private String producerName;
    private String producerVersion;
    private String xmiVersion;

    public String[] getNamespaceURIs() {
        return this.namespaceURIs.toArray(new String[this.namespaceURIs.size()]);
    }

    public String[] getModelImportPaths() {
        String[] result = new String[this.modelImportInfos.size()];
        int i = 0;
        while (i < this.modelImportInfos.size()) {
            ModelImportInfo info = this.modelImportInfos.get(i);
            result[i] = info.getPath();
            ++i;
        }
        return result;
    }

    public String[] getModelImportLocations() {
        String[] result = new String[this.modelImportInfos.size()];
        int i = 0;
        while (i < this.modelImportInfos.size()) {
            ModelImportInfo info = this.modelImportInfos.get(i);
            result[i] = info.getLocation();
            ++i;
        }
        return result;
    }

    public ModelImportInfo[] getModelImportInfos() {
        return this.modelImportInfos.toArray(new ModelImportInfo[this.modelImportInfos.size()]);
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getProducerVersion() {
        return this.producerVersion;
    }

    public String getPrimaryMetamodelURI() {
        return this.primaryMetamodelURI;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelNamespaceUri() {
        return this.modelNamespaceUri;
    }

    public String getXmiVersion() {
        return this.xmiVersion;
    }

    public void addNamespaceURI(String uri) {
        if (!CoreStringUtil.isEmpty((String)uri) && !this.namespaceURIs.contains(uri)) {
            this.namespaceURIs.add(uri);
        }
    }

    public void addModelImportInfo(ModelImportInfo modelImportInfo) {
        if (modelImportInfo != null && !this.modelImportInfos.contains(modelImportInfo)) {
            this.modelImportInfos.add(modelImportInfo);
        }
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public void setProducerVersion(String producerVersion) {
        this.producerVersion = producerVersion;
    }

    public void setPrimaryMetamodelURI(String uri) {
        this.primaryMetamodelURI = uri;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setModelNamespaceUri(String theNamespaceUri) {
        this.modelNamespaceUri = theNamespaceUri;
    }

    public void setXmiVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(String isVisible) {
        this.visible = true;
        if (isVisible.toUpperCase().startsWith("F")) {
            this.visible = false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("XMI Header:");
        sb.append("\n  XMI version:           ");
        sb.append(this.getXmiVersion());
        sb.append("\n  UUID:                  ");
        sb.append(this.getUUID());
        sb.append("\n  Producer:              ");
        sb.append(this.getProducerName());
        sb.append(" ");
        sb.append(this.getProducerVersion());
        sb.append("\n  Description:           ");
        sb.append(this.getDescription());
        sb.append("\n  Model type:            ");
        sb.append(this.getModelType());
        sb.append("\n  Model namespace URI:            ");
        sb.append(this.getModelNamespaceUri());
        sb.append("\n  isVisible:             ");
        sb.append(this.isVisible());
        sb.append("\n  Primary Metamodel URI: ");
        sb.append(this.getPrimaryMetamodelURI());
        sb.append("\n  Namespace URIs:");
        String[] uris = this.getNamespaceURIs();
        int i = 0;
        while (i < uris.length) {
            sb.append("\n    ");
            sb.append(uris[i]);
            ++i;
        }
        sb.append("\n  ModelImportInfos:");
        ModelImportInfo[] infos = this.getModelImportInfos();
        int i2 = 0;
        while (i2 < infos.length) {
            sb.append("\n    ");
            sb.append(infos[i2]);
            ++i2;
        }
        return sb.toString();
    }
}

