/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;

public class LdifNewrdnLine
extends LdifValueLineBase {
    protected LdifNewrdnLine() {
    }

    public LdifNewrdnLine(int offset, String rawNewrdnSpec, String rawValueType, String rawNewrdn, String rawNewLine) {
        super(offset, rawNewrdnSpec, rawValueType, rawNewrdn, rawNewLine);
    }

    public String getRawNewrdnSpec() {
        return super.getRawLineStart();
    }

    public String getUnfoldedNewrdnSpec() {
        return super.getUnfoldedLineStart();
    }

    public String getRawNewrdn() {
        return super.getRawValue();
    }

    public String getUnfoldedNewrdn() {
        return super.getUnfoldedValue();
    }

    @Override
    public String toRawString() {
        return super.toRawString();
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    @Override
    public String getInvalidString() {
        if (this.getUnfoldedNewrdnSpec().length() == 0) {
            return "Missing new Rdn spec 'newrdn'";
        }
        if (this.getUnfoldedNewrdn().length() == 0) {
            return "Missing new Rdn";
        }
        return super.getInvalidString();
    }

    public static LdifNewrdnLine create(String newrdn) {
        if (LdifUtils.mustEncode(newrdn)) {
            return new LdifNewrdnLine(0, "newrdn", "::", LdifUtils.base64encode(LdifUtils.utf8encode(newrdn)), LdifParserConstants.LINE_SEPARATOR);
        }
        return new LdifNewrdnLine(0, "newrdn", ":", newrdn, LdifParserConstants.LINE_SEPARATOR);
    }
}

