/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;

public class LdifChangeAddRecord
extends LdifChangeRecord {
    public LdifChangeAddRecord(LdifDnLine dn) {
        super(dn);
    }

    public void addAttrVal(LdifAttrValLine attrVal) {
        if (attrVal == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(attrVal);
    }

    public LdifAttrValLine[] getAttrVals() {
        ArrayList<LdifAttrValLine> ldifAttrValLines = new ArrayList<LdifAttrValLine>();
        for (Object part : this.ldifParts) {
            if (!(part instanceof LdifAttrValLine)) continue;
            ldifAttrValLines.add((LdifAttrValLine)part);
        }
        return ldifAttrValLines.toArray(new LdifAttrValLine[ldifAttrValLines.size()]);
    }

    public static LdifChangeAddRecord create(String dn) {
        LdifChangeAddRecord record = new LdifChangeAddRecord(LdifDnLine.create(dn));
        record.setChangeType(LdifChangeTypeLine.createAdd());
        return record;
    }

    @Override
    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        for (Object part : this.ldifParts) {
            if (!(part instanceof LdifAttrValLine)) continue;
            return true;
        }
        return false;
    }
}

