/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ConnectionUniversalListener
implements ConnectionUpdateListener {
    protected TreeViewer viewer;
    private IDoubleClickListener viewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            Object obj;
            if (event.getSelection() instanceof IStructuredSelection && (obj = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof ConnectionFolder) {
                if (ConnectionUniversalListener.this.viewer.getExpandedState(obj)) {
                    ConnectionUniversalListener.this.viewer.collapseToLevel(obj, 1);
                } else if (((ITreeContentProvider)ConnectionUniversalListener.this.viewer.getContentProvider()).hasChildren(obj)) {
                    ConnectionUniversalListener.this.viewer.expandToLevel(obj, 1);
                }
            }
        }
    };

    public ConnectionUniversalListener(TreeViewer viewer) {
        this.viewer = viewer;
        this.viewer.addDoubleClickListener(this.viewerDoubleClickListener);
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
    }

    public void dispose() {
        if (this.viewer != null) {
            ConnectionEventRegistry.removeConnectionUpdateListener((ConnectionUpdateListener)this);
            this.viewer = null;
        }
    }

    public void connectionUpdated(Connection connection) {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void connectionAdded(Connection connection) {
        this.connectionUpdated(connection);
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)connection), true);
        }
    }

    public void connectionRemoved(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionOpened(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionClosed(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionFolderModified(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }

    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)connectionFolder), true);
        }
    }

    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }
}

