/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.preferences.Messages;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ConnectionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo networkProviderCombo;
    private Text ldapContextFactoryText;
    private Button useKrb5SystemPropertiesButton;
    private Label krb5LoginModuleNoteLabel;
    private Text krb5LoginModuleText;
    private Label krb5LoginModuleLabel;

    public ConnectionsPreferencePage() {
        super(Messages.getString("ConnectionsPreferencePage.Connections"));
        super.setPreferenceStore(ConnectionUIPlugin.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("ConnectionsPreferencePage.GeneralSettings"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group defaultNetworkProviderGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("ConnectionsPreferencePage.DefaultNetworkProvider"), (int)1);
        ConnectionParameter.NetworkProvider defaultNetworkProvider = ConnectionCorePlugin.getDefault().getDefaultNetworkProvider();
        String[] networkProviders = new String[]{"Apache Directory LDAP Client API", "JNDI (Java Naming and Directory Interface)"};
        this.networkProviderCombo = BaseWidgetUtils.createReadonlyCombo((Composite)defaultNetworkProviderGroup, (String[])networkProviders, (int)0, (int)2);
        this.networkProviderCombo.select(defaultNetworkProvider == ConnectionParameter.NetworkProvider.APACHE_DIRECTORY_LDAP_API ? 0 : 1);
        Group ldapContextFactoryGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("ConnectionsPreferencePage.ContextFactory"), (int)1);
        Preferences preferences = ConnectionCorePlugin.getDefault().getPluginPreferences();
        String ldapCtxFactory = preferences.getString("ldapContextFactory");
        String defaultLdapCtxFactory = preferences.getDefaultString("ldapContextFactory");
        String ldapCtxFactoryNote = NLS.bind((String)Messages.getString("ConnectionsPreferencePage.SystemDetectedContextFactory"), (Object)defaultLdapCtxFactory);
        this.ldapContextFactoryText = BaseWidgetUtils.createText((Composite)ldapContextFactoryGroup, (String)ldapCtxFactory, (int)1);
        BaseWidgetUtils.createWrappedLabel((Composite)ldapContextFactoryGroup, (String)ldapCtxFactoryNote, (int)1);
        Group krb5SettingsGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("ConnectionsPreferencePage.Krb5Settings"), (int)1);
        boolean useKrb5SystemProperties = preferences.getBoolean("useKrb5SystemProperties");
        this.useKrb5SystemPropertiesButton = BaseWidgetUtils.createCheckbox((Composite)krb5SettingsGroup, (String)Messages.getString("ConnectionsPreferencePage.UseKrb5SystemProperties"), (int)1);
        this.useKrb5SystemPropertiesButton.setToolTipText(Messages.getString("ConnectionsPreferencePage.UseKrb5SystemPropertiesTooltip"));
        this.useKrb5SystemPropertiesButton.setSelection(useKrb5SystemProperties);
        this.krb5LoginModuleLabel = BaseWidgetUtils.createLabel((Composite)krb5SettingsGroup, (String)Messages.getString("ConnectionsPreferencePage.Krb5LoginModule"), (int)1);
        String krb5LoginModule = preferences.getString("krb5LoginModule");
        String defaultKrb5LoginModule = preferences.getDefaultString("krb5LoginModule");
        String krb5LoginModuleNote = NLS.bind((String)Messages.getString("ConnectionsPreferencePage.SystemDetectedContextFactory"), (Object)defaultKrb5LoginModule);
        this.krb5LoginModuleText = BaseWidgetUtils.createText((Composite)krb5SettingsGroup, (String)krb5LoginModule, (int)1);
        this.krb5LoginModuleNoteLabel = BaseWidgetUtils.createWrappedLabel((Composite)krb5SettingsGroup, (String)krb5LoginModuleNote, (int)1);
        this.useKrb5SystemPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsPreferencePage.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    private void validate() {
        this.krb5LoginModuleLabel.setEnabled(!this.useKrb5SystemPropertiesButton.getSelection());
        this.krb5LoginModuleText.setEnabled(!this.useKrb5SystemPropertiesButton.getSelection());
        this.krb5LoginModuleNoteLabel.setEnabled(!this.useKrb5SystemPropertiesButton.getSelection());
    }

    protected void performDefaults() {
        ConnectionParameter.NetworkProvider defaultdDefaultNetworkProvider = ConnectionCorePlugin.getDefault().getNetworkProvider(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultInt("defaultNetworkProvider"));
        this.networkProviderCombo.select(defaultdDefaultNetworkProvider == ConnectionParameter.NetworkProvider.APACHE_DIRECTORY_LDAP_API ? 0 : 1);
        this.ldapContextFactoryText.setText(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultString("ldapContextFactory"));
        this.krb5LoginModuleText.setText(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultString("krb5LoginModule"));
        this.useKrb5SystemPropertiesButton.setSelection(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean("useKrb5SystemProperties"));
        super.performDefaults();
    }

    public boolean performOk() {
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("defaultNetworkProvider", this.getNetworkProviderValue());
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("ldapContextFactory", this.ldapContextFactoryText.getText());
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("krb5LoginModule", this.krb5LoginModuleText.getText());
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("useKrb5SystemProperties", this.useKrb5SystemPropertiesButton.getSelection());
        ConnectionCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private int getNetworkProviderValue() {
        switch (this.networkProviderCombo.getSelectionIndex()) {
            case 1: {
                return 0;
            }
        }
        return 1;
    }
}

