/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dialogs;

import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.ui.dialogs.Messages;
import org.apache.directory.studio.connection.ui.widgets.ConnectionActionGroup;
import org.apache.directory.studio.connection.ui.widgets.ConnectionConfiguration;
import org.apache.directory.studio.connection.ui.widgets.ConnectionUniversalListener;
import org.apache.directory.studio.connection.ui.widgets.ConnectionWidget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectReferralConnectionDialog
extends Dialog {
    private String title;
    private List<String> referralUrls;
    private Connection selectedConnection;
    private ConnectionConfiguration configuration;
    private ConnectionUniversalListener universalListener;
    private ConnectionActionGroup actionGroup;
    private ConnectionWidget mainWidget;

    public SelectReferralConnectionDialog(Shell parentShell, List<String> referralUrls) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.title = Messages.getString("SelectReferralConnectionDialog.SelectReferralConenction");
        this.referralUrls = referralUrls;
        this.selectedConnection = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public boolean close() {
        if (this.mainWidget != null) {
            this.configuration.dispose();
            this.configuration = null;
            this.actionGroup.deactivateGlobalActionHandlers();
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.universalListener.dispose();
            this.universalListener = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
        }
        return super.close();
    }

    protected void cancelPressed() {
        this.selectedConnection = null;
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.setFocus();
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    private void validate() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.selectedConnection != null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        composite.setLayoutData((Object)gd);
        BaseWidgetUtils.createWrappedLabeledText((Composite)composite, (String)Messages.getString("SelectReferralConnectionDialog.SelectConnectionToHandleReferral"), (int)1);
        for (String url : this.referralUrls) {
            BaseWidgetUtils.createWrappedLabeledText((Composite)composite, (String)(" - " + url), (int)1);
        }
        this.configuration = new ConnectionConfiguration();
        this.mainWidget = new ConnectionWidget(this.configuration, null);
        this.mainWidget.createWidget(composite);
        this.mainWidget.setInput(ConnectionCorePlugin.getDefault().getConnectionFolderManager());
        this.actionGroup = new ConnectionActionGroup(this.mainWidget, this.configuration);
        this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
        this.actionGroup.fillContextMenu(this.mainWidget.getContextMenuManager());
        this.actionGroup.activateGlobalActionHandlers();
        this.universalListener = new ConnectionUniversalListener(this.mainWidget.getViewer());
        this.mainWidget.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                SelectReferralConnectionDialog.this.selectedConnection = null;
                if (!event.getSelection().isEmpty() && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Connection) {
                    SelectReferralConnectionDialog.this.selectedConnection = (Connection)o;
                }
                SelectReferralConnectionDialog.this.validate();
            }
        });
        this.mainWidget.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o;
                SelectReferralConnectionDialog.this.selectedConnection = null;
                if (!event.getSelection().isEmpty() && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Connection) {
                    SelectReferralConnectionDialog.this.selectedConnection = (Connection)o;
                }
                SelectReferralConnectionDialog.this.validate();
            }
        });
        if (this.referralUrls != null) {
            Connection[] connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
            int i = 0;
            while (i < connections.length) {
                Connection connection = connections[i];
                LdapUrl connectionUrl = connection.getUrl();
                String normalizedConnectionUrl = Utils.getSimpleNormalizedUrl((LdapUrl)connectionUrl);
                for (String url : this.referralUrls) {
                    try {
                        if (url == null || !Utils.getSimpleNormalizedUrl((LdapUrl)new LdapUrl(url)).equals(normalizedConnectionUrl)) continue;
                        this.mainWidget.getViewer().reveal((Object)connection);
                        this.mainWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)connection), true);
                        break;
                    }
                    catch (LdapURLEncodingException ldapURLEncodingException) {}
                }
                ++i;
            }
        }
        SelectReferralConnectionDialog.applyDialogFont((Control)composite);
        this.validate();
        return composite;
    }

    public Connection getReferralConnection() {
        return this.selectedConnection;
    }
}

