/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import java.security.KeyStoreException;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.ui.Messages;
import org.apache.directory.studio.connection.ui.dialogs.PasswordDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PasswordsKeyStoreManagerUtils {
    public static boolean isPasswordsKeystoreEnabled() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getInt("connectionsPasswordsKeystore") == 1;
    }

    public static boolean askUserToLoadKeystore() {
        final boolean[] keystoreLoaded = new boolean[]{false};
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                block5: {
                    String message;
                    Shell shell;
                    MessageDialog errorDialog;
                    do {
                        KeyStoreException checkPasswordException;
                        block4: {
                            PasswordDialog passwordDialog;
                            if ((passwordDialog = new PasswordDialog(shell = PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("PasswordsKeyStoreManagerUtils.VerifyMasterPassword"), Messages.getString("PasswordsKeyStoreManagerUtils.PleaseEnterMasterPassword"), null)).open() == 1) {
                                keystoreLoaded[0] = false;
                                return;
                            }
                            String masterPassword = passwordDialog.getPassword();
                            checkPasswordException = null;
                            try {
                                if (!ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager().checkMasterPassword(masterPassword)) break block4;
                                keystoreLoaded[0] = true;
                                break block5;
                            }
                            catch (KeyStoreException e) {
                                checkPasswordException = e;
                            }
                        }
                        message = null;
                        message = checkPasswordException != null ? String.valueOf(Messages.getString("PasswordsKeyStoreManagerUtils.MasterPasswordVerificationFailedWithException")) + checkPasswordException.getMessage() : Messages.getString("PasswordsKeyStoreManagerUtils.MasterPasswordVerificationFailed");
                    } while ((errorDialog = new MessageDialog(shell, Messages.getString("PasswordsKeyStoreManagerUtils.VerifyMasterPasswordFailed"), null, message, 1, new String[]{IDialogConstants.RETRY_LABEL, IDialogConstants.CANCEL_LABEL}, 0)).open() != 1);
                    keystoreLoaded[0] = false;
                    return;
                }
            }
        });
        return keystoreLoaded[0];
    }
}

