/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class ResolveQName
extends SystemFunction {
    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        StructuredQName qName;
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return null;
        }
        CharSequence lexicalQName = arg0.getStringValueCS();
        NameChecker checker = context.getConfiguration().getNameChecker();
        NodeInfo element = (NodeInfo)this.argument[1].evaluateItem(context);
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, true, checker, resolver);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
        return new QNameValue(qName, BuiltInAtomicType.QNAME);
    }
}

